/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments.poster;

import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPayment;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPost;
import se.swedsoft.bookkeeping.importexport.supplierpayments.util.LBinLine;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;

public class LBinPostTK26
extends LBinPost {
    private Integer iOutpaymentNumber;
    private String iName;

    public LBinPostTK26() {
    }

    public LBinPostTK26(SupplierPayment iPayment) {
        this.iOutpaymentNumber = iPayment.getOutpaymentNumber();
        this.iName = iPayment.getAddress().getName();
        if (this.iName == null) {
            throw new SSExportException(SSBundle.getBundle(), "supplierpaymentframe.error.supplieraddress", iPayment.getSupplier().getName());
        }
    }

    @Override
    public void write(LBinLine iLine) {
        iLine.append("26");
        iLine.append("0000", 4, '0');
        iLine.append(this.iOutpaymentNumber, 5);
        iLine.append(" ");
        iLine.append(this.iName.toUpperCase(), 35);
        iLine.append("", 33);
    }

    @Override
    public void read(LBinLine iLine) {
        this.iOutpaymentNumber = iLine.readInteger(3, 12);
        this.iName = iLine.readString(13, 47);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK26");
        sb.append("{iName='").append(this.iName).append('\'');
        sb.append(", iOutpaymentNumber=").append(this.iOutpaymentNumber);
        sb.append('}');
        return sb.toString();
    }
}

