/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments.poster;

import java.math.BigDecimal;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPaymentConfig;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPost;
import se.swedsoft.bookkeeping.importexport.supplierpayments.util.LBinLine;

public class LBinPostTK29
extends LBinPost {
    private String iBankGiroNr;
    private int iSize;
    private BigDecimal iSum;

    public LBinPostTK29() {
    }

    public LBinPostTK29(int iSize, BigDecimal iSum) {
        this.iBankGiroNr = SupplierPaymentConfig.getOurBankGiroAccount().replaceAll("-", "");
        this.iSize = iSize;
        this.iSum = iSum;
    }

    @Override
    public void write(LBinLine iLine) {
        iLine.append("29");
        iLine.append(this.iBankGiroNr, 10, '0');
        iLine.append(this.iSize, 8);
        iLine.append(this.iSum, 12);
        iLine.append(" ", 1);
        iLine.append(" ", 47);
    }

    @Override
    public void read(LBinLine iLine) {
        this.iBankGiroNr = iLine.readString(3, 12);
        this.iSize = iLine.readInteger(13, 20);
        this.iSum = iLine.readBigDecimal(21, 32);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK29");
        sb.append("{iBankGiroNr='").append(this.iBankGiroNr).append('\'');
        sb.append(", iSize=").append(this.iSize);
        sb.append(", iSum=").append(this.iSum);
        sb.append('}');
        return sb.toString();
    }
}

