/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import se.swedsoft.bookkeeping.app.Path;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSOrderImporter {
    private File iFile;
    private List<SSCustomer> iCustomers = new LinkedList<SSCustomer>();
    private List<SSProduct> iProducts = new LinkedList<SSProduct>();

    public SSOrderImporter(File pFile) {
        this.iFile = pFile;
    }

    public void doImport() throws SSImportException {
        LinkedList<SSOrder> iOrders = new LinkedList<SSOrder>();
        try {
            DocumentBuilderFactory iDocBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder iDocBuilder = iDocBuilderFactory.newDocumentBuilder();
            Document iDoc = iDocBuilder.parse(this.iFile.getAbsolutePath());
            iDoc.getDocumentElement().normalize();
            if (!iDoc.getDocumentElement().getNodeName().equals("Orders")) {
                throw new SSImportException("Filen inneh\u00e5ller inga ordrar");
            }
            NodeList iOrderList = iDoc.getElementsByTagName("Order");
            if (iOrderList.getLength() == 0) {
                throw new SSImportException("Filen inneh\u00e5ller inga ordrar");
            }
            for (int i = 0; i < iOrderList.getLength(); ++i) {
                SSCurrency iCurrency;
                SSOrder iOrder = new SSOrder();
                Node iOrderNode = iOrderList.item(i);
                if (iOrderNode.getNodeType() != 1) continue;
                NodeList iTextOrderAttList = null;
                String iValue = null;
                Element iOrderElement = (Element)iOrderNode;
                NodeList iOrderAttList = iOrderElement.getElementsByTagName("SellerOrderNo");
                Element iFirstOrderAttElement = (Element)iOrderAttList.item(0);
                if (iFirstOrderAttElement != null) {
                    iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                    iValue = iTextOrderAttList.item(0).getNodeValue() == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                    iOrder.setNumber(iValue == null ? 0 : Integer.parseInt(iValue));
                }
                if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("OrderDate")).item(0)) != null) {
                    iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                    iValue = iTextOrderAttList.item(0).getNodeValue() == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                    SimpleDateFormat iFormat = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        iOrder.setDate(iValue == null ? new Date() : iFormat.parse(iValue));
                    }
                    catch (ParseException e) {
                        iOrder.setDate(new Date());
                    }
                }
                if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DelayInterest")).item(0)) != null) {
                    iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                    iValue = iTextOrderAttList.item(0) == null ? "0.0" : iTextOrderAttList.item(0).getNodeValue().trim();
                    iOrder.setDelayInterest(new BigDecimal(iValue));
                }
                if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("Text")).item(0)) != null) {
                    iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                    iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                    iOrder.setText(iValue);
                }
                if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("TaxRate1")).item(0)) != null) {
                    iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                    iValue = iTextOrderAttList.item(0) == null ? "0.0" : iTextOrderAttList.item(0).getNodeValue().trim();
                    iOrder.setTaxRate1(new BigDecimal(iValue));
                }
                if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("TaxRate2")).item(0)) != null) {
                    iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                    iValue = iTextOrderAttList.item(0) == null ? "0.0" : iTextOrderAttList.item(0).getNodeValue().trim();
                    iOrder.setTaxRate2(new BigDecimal(iValue));
                }
                if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("TaxRate3")).item(0)) != null) {
                    iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                    iValue = iTextOrderAttList.item(0) == null ? "0.0" : iTextOrderAttList.item(0).getNodeValue().trim();
                    iOrder.setTaxRate3(new BigDecimal(iValue));
                }
                iValue = null;
                iOrderAttList = iOrderElement.getElementsByTagName("CustomerNumber");
                iFirstOrderAttElement = (Element)iOrderAttList.item(0);
                SSCustomer iCustomer = null;
                if (iFirstOrderAttElement != null) {
                    iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                    iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                    iCustomer = this.getCustomer(iValue);
                }
                if (iCustomer != null) {
                    iOrder.setCustomer(iCustomer);
                    iOrderAttList = iOrderElement.getElementsByTagName("CurrencyCode");
                    iFirstOrderAttElement = (Element)iOrderAttList.item(0);
                    if (iFirstOrderAttElement != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCurrency = this.getCurrency(iValue);
                        iOrder.setCurrency(iCurrency);
                        iOrder.setCurrencyRate(iCurrency.getExchangeRate());
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("PaymentTerms")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iOrder.setPaymentTerm(this.getPaymentTerm(iValue));
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DeliveryTerms")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iOrder.setDeliveryTerm(this.getDeliveryTerm(iValue));
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DeliveryMethod")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iOrder.setDeliveryWay(this.getDeliveryWay(iValue));
                    }
                } else {
                    iCustomer = new SSCustomer();
                    iCustomer.setNumber(iValue);
                    iOrderAttList = iOrderElement.getElementsByTagName("CustomerName");
                    iFirstOrderAttElement = (Element)iOrderAttList.item(0);
                    if (iFirstOrderAttElement != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setName(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("OurContactPerson")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setOurContactPerson(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("YourContactPerson")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setYourContactPerson(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("CurrencyCode")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCurrency = this.getCurrency(iValue);
                        iCustomer.setInvoiceCurrency(iCurrency);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("PaymentTerms")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setPaymentTerm(this.getPaymentTerm(iValue));
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DeliveryTerms")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setDeliveryTerm(this.getDeliveryTerm(iValue));
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DeliveryMethod")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setDeliveryWay(this.getDeliveryWay(iValue));
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("TaxFree")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setTaxFree(Boolean.valueOf(iValue));
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("EuSaleCommodity")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setEuSaleCommodity(Boolean.valueOf(iValue));
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("EuSaleThirdPartCommodity")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setEuSaleYhirdPartCommodity(Boolean.valueOf(iValue));
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("VATRegNo")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setVATNumber(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("Email")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setEMail(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("CompanyNo")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setRegistrationNumber(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("Telefax")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setTelefax(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("Telephone")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setPhone1(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("Telephone2")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iCustomer.setPhone2(iValue);
                    }
                    SSAddress iInvoiceAddress = new SSAddress();
                    iOrderAttList = iOrderElement.getElementsByTagName("InvoiceName");
                    iFirstOrderAttElement = (Element)iOrderAttList.item(0);
                    if (iFirstOrderAttElement != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iInvoiceAddress.setName(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("InvoiceAddress1")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iInvoiceAddress.setAddress1(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("InvoiceAddress2")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iInvoiceAddress.setAddress2(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("InvoicePostCode")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iInvoiceAddress.setZipCode(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("InvoicePostOffice")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iInvoiceAddress.setCity(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("InvoiceCountry")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iInvoiceAddress.setCountry(iValue);
                    }
                    iCustomer.setInvoiceAddress(iInvoiceAddress);
                    SSAddress iDeliveryAddress = new SSAddress();
                    iOrderAttList = iOrderElement.getElementsByTagName("DeliveryName");
                    iFirstOrderAttElement = (Element)iOrderAttList.item(0);
                    if (iFirstOrderAttElement != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iDeliveryAddress.setName(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DeliveryAddress1")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iDeliveryAddress.setAddress1(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DeliveryAddress2")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iDeliveryAddress.setAddress2(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DeliveryPostCode")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iDeliveryAddress.setZipCode(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DeliveryPostOffice")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iDeliveryAddress.setCity(iValue);
                    }
                    if ((iFirstOrderAttElement = (Element)(iOrderAttList = iOrderElement.getElementsByTagName("DeliveryCountry")).item(0)) != null) {
                        iTextOrderAttList = iFirstOrderAttElement.getChildNodes();
                        iValue = iTextOrderAttList.item(0) == null ? "" : iTextOrderAttList.item(0).getNodeValue().trim();
                        iDeliveryAddress.setCountry(iValue);
                    }
                    iCustomer.setDeliveryAddress(iDeliveryAddress);
                    iOrder.setCustomer(iCustomer);
                    if (iCustomer.getNumber() != null) {
                        this.iCustomers.add(iCustomer);
                    }
                }
                iOrderAttList = iOrderElement.getElementsByTagName("Detail");
                iFirstOrderAttElement = (Element)iOrderAttList.item(0);
                NodeList iRowList = iFirstOrderAttElement.getElementsByTagName("ArticleRow");
                for (int j = 0; j < iRowList.getLength(); ++j) {
                    SSSaleRow iRow = new SSSaleRow();
                    Node iRowNode = iRowList.item(j);
                    if (iRowNode.getNodeType() != 1) continue;
                    Element iRowElement = (Element)iRowNode;
                    NodeList iTextRowAttList = null;
                    NodeList iRowAttList = iRowElement.getElementsByTagName("QuantityOrdered");
                    Element iFirstRowAttElement = (Element)iRowAttList.item(0);
                    if (iFirstOrderAttElement != null) {
                        iTextRowAttList = iFirstRowAttElement.getChildNodes();
                        iValue = iTextRowAttList.item(0) == null ? "0" : iTextRowAttList.item(0).getNodeValue().trim();
                        iRow.setQuantity(Integer.parseInt(iValue));
                    }
                    iRowAttList = iRowElement.getElementsByTagName("TotalLineDiscountPercent");
                    iFirstRowAttElement = (Element)iRowAttList.item(0);
                    if (iFirstOrderAttElement != null) {
                        iTextRowAttList = iFirstRowAttElement.getChildNodes();
                        iValue = iTextRowAttList.item(0) == null ? null : iTextRowAttList.item(0).getNodeValue().trim();
                        iRow.setDiscount(iValue == null ? null : new BigDecimal(iValue));
                    }
                    iRowAttList = iRowElement.getElementsByTagName("SellerArticleNo");
                    iFirstRowAttElement = (Element)iRowAttList.item(0);
                    SSProduct iProduct = null;
                    if (iFirstOrderAttElement != null) {
                        iTextRowAttList = iFirstRowAttElement.getChildNodes();
                        iValue = iTextRowAttList.item(0) == null ? "" : iTextRowAttList.item(0).getNodeValue().trim();
                        iProduct = this.getProduct(iValue);
                    }
                    if (iProduct != null) {
                        iRow.setProductOnly(iProduct);
                        iRowAttList = iRowElement.getElementsByTagName("UnitPrice");
                        iFirstRowAttElement = (Element)iRowAttList.item(0);
                        if (iFirstOrderAttElement != null) {
                            iTextRowAttList = iFirstRowAttElement.getChildNodes();
                            iValue = iTextRowAttList.item(0) == null ? "0.0" : iTextRowAttList.item(0).getNodeValue().trim();
                            iRow.setUnitprice(new BigDecimal(iValue));
                        }
                    } else {
                        iProduct = new SSProduct();
                        iProduct.setNumber(iValue);
                        iRowAttList = iRowElement.getElementsByTagName("ArticleDescription");
                        iFirstRowAttElement = (Element)iRowAttList.item(0);
                        if (iFirstOrderAttElement != null) {
                            iTextRowAttList = iFirstRowAttElement.getChildNodes();
                            iValue = iTextRowAttList.item(0) == null ? "" : iTextRowAttList.item(0).getNodeValue().trim();
                            iProduct.setDescription(iValue);
                        }
                        iRowAttList = iRowElement.getElementsByTagName("UnitPrice");
                        iFirstRowAttElement = (Element)iRowAttList.item(0);
                        if (iFirstOrderAttElement != null) {
                            iTextRowAttList = iFirstRowAttElement.getChildNodes();
                            iValue = iTextRowAttList.item(0) == null ? "0.0" : iTextRowAttList.item(0).getNodeValue().trim();
                            iProduct.setSellingPrice(new BigDecimal(iValue));
                        }
                        iRowAttList = iRowElement.getElementsByTagName("Unit");
                        iFirstRowAttElement = (Element)iRowAttList.item(0);
                        if (iFirstOrderAttElement != null) {
                            iTextRowAttList = iFirstRowAttElement.getChildNodes();
                            iValue = iTextRowAttList.item(0) == null ? "" : iTextRowAttList.item(0).getNodeValue().trim();
                            iProduct.setUnit(this.getUnit(iValue));
                        }
                        iRowAttList = iRowElement.getElementsByTagName("VATPercentage");
                        iFirstRowAttElement = (Element)iRowAttList.item(0);
                        if (iFirstOrderAttElement != null) {
                            iTextRowAttList = iFirstRowAttElement.getChildNodes();
                            iValue = iTextRowAttList.item(0) == null ? "" : iTextRowAttList.item(0).getNodeValue().trim();
                            iProduct.setTaxCode(SSTaxCode.decode(iValue));
                        }
                        if (iProduct.getNumber() != null) {
                            this.iProducts.add(iProduct);
                        }
                        iRow.setProductOnly(iProduct);
                    }
                    if (iRow.getProductNr() == null) continue;
                    iOrder.getRows().add(iRow);
                }
                if (iOrder.getCustomerNr() == null) continue;
                iOrders.add(iOrder);
            }
            for (SSProduct iProduct : this.iProducts) {
                SSDB.getInstance().addProduct(iProduct);
            }
            for (SSCustomer iCustomer : this.iCustomers) {
                SSDB.getInstance().addCustomer(iCustomer);
            }
            for (SSOrder iNewOrder : iOrders) {
                SSDB.getInstance().addOrder(iNewOrder);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SSImportException(e.getMessage());
        }
        catch (SAXException e) {
            throw new SSImportException(e.getMessage());
        }
        catch (IOException e) {
            throw new SSImportException(e.getMessage());
        }
    }

    private SSCustomer getCustomer(String iNumber) {
        List<SSCustomer> pCustomers = SSDB.getInstance().getCustomers();
        for (SSCustomer iCustomer : pCustomers) {
            if (!iCustomer.getNumber().equals(iNumber)) continue;
            return iCustomer;
        }
        for (SSCustomer iCustomer : this.iCustomers) {
            if (!iCustomer.getNumber().equals(iNumber)) continue;
            return iCustomer;
        }
        return null;
    }

    private SSCurrency getCurrency(String iName) {
        List<SSCurrency> iCurrencies = SSDB.getInstance().getCurrencies();
        for (SSCurrency iCurrency : iCurrencies) {
            if (!iCurrency.getName().equals(iName)) continue;
            return iCurrency;
        }
        return null;
    }

    private SSPaymentTerm getPaymentTerm(String iName) {
        List<SSPaymentTerm> iPaymentTerms = SSDB.getInstance().getPaymentTerms();
        for (SSPaymentTerm iPaymentTerm : iPaymentTerms) {
            if (!iPaymentTerm.getName().equals(iName)) continue;
            return iPaymentTerm;
        }
        return null;
    }

    private SSDeliveryTerm getDeliveryTerm(String iName) {
        List<SSDeliveryTerm> iDeliveryTerms = SSDB.getInstance().getDeliveryTerms();
        for (SSDeliveryTerm iDeliveryTerm : iDeliveryTerms) {
            if (!iDeliveryTerm.getName().equals(iName)) continue;
            return iDeliveryTerm;
        }
        return null;
    }

    private SSDeliveryWay getDeliveryWay(String iName) {
        List<SSDeliveryWay> iDeliveryWays = SSDB.getInstance().getDeliveryWays();
        for (SSDeliveryWay iDeliveryWay : iDeliveryWays) {
            if (!iDeliveryWay.getName().equals(iName)) continue;
            return iDeliveryWay;
        }
        return null;
    }

    private SSProduct getProduct(String iName) {
        List<SSProduct> iProducts = SSDB.getInstance().getProducts();
        for (SSProduct iProduct : iProducts) {
            if (!iProduct.getNumber().equals(iName)) continue;
            return iProduct;
        }
        for (SSProduct iProduct : this.iProducts) {
            if (!iProduct.getNumber().equals(iName)) continue;
            return iProduct;
        }
        return null;
    }

    private SSUnit getUnit(String iName) {
        List<SSUnit> iUnits = SSDB.getInstance().getUnits();
        for (SSUnit iUnit : iUnits) {
            if (!iUnit.getName().equals(iName)) continue;
            return iUnit;
        }
        return null;
    }

    public void doEbutikImport() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.iFile), "Windows-1252"));
            String text = null;
            ArrayList<String> al = new ArrayList<String>();
            HashMap iResult = new HashMap();
            while ((text = br.readLine()) != null) {
                al.add(text);
            }
            br.close();
            for (String iLine : al) {
                if (iLine.length() == 0) continue;
                String[] iFields = iLine.split("\t", 2);
                Integer iOrderNumber = Integer.parseInt(iFields[0]);
                if (iResult.get(iOrderNumber) == null) {
                    ArrayList<String> iLineData = new ArrayList<String>();
                    iLineData.add(iFields[1]);
                    iResult.put(iOrderNumber, iLineData);
                    continue;
                }
                ((ArrayList)iResult.get(iOrderNumber)).add(iFields[1]);
            }
            LinkedList<String> iBadOrders = new LinkedList<String>();
            if (SSDB.getInstance().getProduct("frakt") == null) {
                SSErrorDialog.showDialog(SSMainFrame.getInstance(), "", "Du m\u00e5ste skapa en produkt med nummer \"Frakt\" innan du kan importera.");
                return;
            }
            if (SSDB.getInstance().getProduct("avgift") == null) {
                SSErrorDialog.showDialog(SSMainFrame.getInstance(), "", "Du m\u00e5ste skapa en produkt med nummer \"Avgift\" innan du kan importera.");
                return;
            }
            ArrayList iOrderNumbers = new ArrayList(iResult.keySet());
            Collections.sort(iOrderNumbers);
            Integer iOrderCount = 0;
            block20: for (Integer iOrderNumber : iOrderNumbers) {
                SSSaleRow iRow;
                SSOrder iOrder = new SSOrder();
                Iterable iAl = (Iterable)iResult.get(iOrderNumber);
                String iFeeString = "";
                String iFreightString = "";
                String iPaymentString = "";
                for (String iLine : iAl) {
                    String[] iFields = iLine.split("\t");
                    if (iOrder.getCustomer() == null && iFields[0] != null) {
                        SSCustomer iCustomer = SSDB.getInstance().getCustomer(iFields[0]);
                        if (iCustomer == null) {
                            iBadOrders.add(iOrderNumber + " - Kunden " + iFields[0] + " existerar inte.");
                            continue block20;
                        }
                        iOrder.setCustomer(iCustomer);
                    } else if (iFields[0] == null) {
                        iBadOrders.add(iOrderNumber + " - Kund-id saknas");
                        continue block20;
                    }
                    if (iFields[1] != null) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            iOrder.setDate(df.parse(iFields[1]));
                        }
                        catch (ParseException e) {
                            iBadOrders.add(iOrderNumber + " - Orderdatum \u00e4r i fel format");
                            continue block20;
                        }
                    }
                    SSSaleRow iRow2 = new SSSaleRow();
                    if (iFields[2] != null) {
                        SSProduct iProduct = SSDB.getInstance().getProduct(iFields[2]);
                        if (iProduct != null) {
                            iRow2.setProduct(iProduct);
                            iRow2.setDescription(iFields[3]);
                            if (iFields[6] != null) {
                                try {
                                    iFields[6] = iFields[6].replace(",", ".");
                                    iRow2.setUnitprice(new BigDecimal(iFields[6]));
                                }
                                catch (Exception e) {
                                    iRow2.setUnitprice(new BigDecimal(0));
                                }
                            }
                        } else {
                            iProduct = new SSProduct();
                            iProduct.setNumber(iFields[2]);
                            if (iFields[3] != null) {
                                iProduct.setDescription(iFields[3]);
                            }
                            try {
                                iFields[6] = iFields[6].replace(",", ".");
                                iProduct.setSellingPrice(new BigDecimal(iFields[6]));
                            }
                            catch (Exception e) {
                                iProduct.setSellingPrice(new BigDecimal(0));
                            }
                            try {
                                iFields[6] = iFields[6].replace(",", ".");
                                iFields[8] = iFields[8].replace(",", ".");
                                BigDecimal iGrossSum = new BigDecimal(iFields[6]);
                                BigDecimal iTaxSum = new BigDecimal(iFields[8]);
                                BigDecimal iTaxPercent = iTaxSum.divide(iGrossSum);
                                iTaxPercent = iTaxPercent.multiply(new BigDecimal(100));
                                iTaxPercent = iTaxPercent.setScale(0);
                                iProduct.setTaxCode(SSTaxCode.decode2(iTaxPercent.toString()));
                            }
                            catch (Exception e) {
                                iProduct.setTaxCode(SSTaxCode.TAXRATE_1);
                            }
                            try {
                                iProduct.setWeight(new BigDecimal(iFields[9]));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            iRow2.setProduct(iProduct);
                            SSDB.getInstance().addProduct(iProduct);
                        }
                    } else {
                        iBadOrders.add(iOrderNumber + " - Artikelnummer saknas.");
                        continue block20;
                    }
                    try {
                        iRow2.setQuantity(Integer.parseInt(iFields[5]));
                    }
                    catch (Exception e) {
                        iRow2.setQuantity(0);
                    }
                    iOrder.getRows().add(iRow2);
                    iFeeString = iFields[13];
                    iFreightString = iFields[15];
                    iPaymentString = iFields[14];
                }
                if (iFeeString != null && iFeeString.length() != 0 && !iFeeString.equals("0")) {
                    try {
                        iFeeString = iFeeString.replace(",", ".");
                        iRow = new SSSaleRow(SSDB.getInstance().getProduct("Avgift"));
                        BigDecimal iFee = new BigDecimal(iFeeString);
                        iFee = iFee.multiply(new BigDecimal("0.8"));
                        iRow.setUnitprice(iFee);
                        iRow.setQuantity(1);
                        iOrder.getRows().add(iRow);
                    }
                    catch (Exception e) {
                        iBadOrders.add(iOrderNumber + " - Kunde inte skapa produktrad f\u00f6r avgift");
                        continue;
                    }
                }
                if (iFreightString != null && iFreightString.length() != 0 && !iFreightString.equals("0")) {
                    try {
                        iFreightString = iFreightString.replace(",", ".");
                        iRow = new SSSaleRow(SSDB.getInstance().getProduct("Frakt"));
                        BigDecimal iFreight = new BigDecimal(iFreightString);
                        iFreight = iFreight.multiply(new BigDecimal("0.8"));
                        iRow.setUnitprice(iFreight);
                        iRow.setQuantity(1);
                        iOrder.getRows().add(iRow);
                    }
                    catch (Exception e) {
                        iBadOrders.add(iOrderNumber + " - Kunde inte skapa produktrad f\u00f6r frakt");
                        continue;
                    }
                }
                if (iPaymentString != null && iPaymentString.length() != 0) {
                    boolean set = false;
                    for (SSPaymentTerm iPaymentTerm : SSDB.getInstance().getPaymentTerms()) {
                        if (!iPaymentTerm.getDescription().equals(iPaymentString)) continue;
                        iOrder.setPaymentTerm(iPaymentTerm);
                        set = true;
                    }
                    if (!set) {
                        iOrder.setPaymentTerm(SSDB.getInstance().getCurrentCompany().getPaymentTerm());
                    }
                }
                Integer n = iOrderCount;
                iOrderCount = iOrderCount + 1;
                Integer n2 = iOrderCount;
                SSDB.getInstance().addOrder(iOrder);
            }
            if (!iBadOrders.isEmpty()) {
                BufferedWriter bw = new BufferedWriter(new PrintWriter(new File(Path.get(Path.APP_BASE), "orderimport.txt")));
                for (String iBadOrder : iBadOrders) {
                    bw.write(iBadOrder);
                    bw.newLine();
                }
                bw.close();
                new SSInformationDialog(SSMainFrame.getInstance(), "orderframe.import.errors", iOrderCount.toString(), String.valueOf(iBadOrders.size()));
            } else {
                new SSInformationDialog(SSMainFrame.getInstance(), "orderframe.import.noerrors", iOrderCount.toString());
            }
        }
        catch (IOException e) {
            throw new SSImportException(e.getMessage());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.xml.SSOrderImporter");
        sb.append("{iCustomers=").append(this.iCustomers);
        sb.append(", iFile=").append(this.iFile);
        sb.append(", iProducts=").append(this.iProducts);
        sb.append('}');
        return sb.toString();
    }
}

