/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSMultiPrinter
extends SSPrinter {
    private List<SSSubReport> iSubReports = new LinkedList<SSSubReport>();

    public SSMultiPrinter() {
        this.setMargins(0, 0, 0, 0);
        this.setDetail("multireport.jrxml");
    }

    @Override
    public String getTitle() {
        if (!this.iSubReports.isEmpty()) {
            SSSubReport iSubReport = this.iSubReports.get(0);
            return iSubReport.iName;
        }
        return "";
    }

    @Override
    protected SSDefaultTableModel getModel() {
        SSDefaultTableModel<SSSubReport> iModel = new SSDefaultTableModel<SSSubReport>(){

            @Override
            public Class getType() {
                return String.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSSubReport iSubReport = (SSSubReport)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iSubReport.iName;
                        break;
                    }
                    case 1: {
                        value = iSubReport.iReport;
                        break;
                    }
                    case 2: {
                        value = iSubReport.iDataSource;
                        break;
                    }
                    case 3: {
                        value = iSubReport.iParameters;
                        break;
                    }
                    case 4: {
                        value = iSubReport.iBundle;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("report.name");
        iModel.addColumn("report.report");
        iModel.addColumn("report.datasource");
        iModel.addColumn("report.parameters");
        iModel.addColumn("report.bundle");
        iModel.setObjects(this.iSubReports);
        return iModel;
    }

    public void addReport(SSPrinter pReport) {
        SSSubReport iSubReport = new SSSubReport();
        pReport.generateReport();
        iSubReport.iName = pReport.getTitle();
        iSubReport.iReport = pReport.getReport();
        iSubReport.iDataSource = new SSDefaultJasperDataSource(pReport.getModel());
        iSubReport.iParameters = pReport.getParameters();
        iSubReport.iBundle = pReport.getBundle();
        this.iSubReports.add(iSubReport);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.SSMultiPrinter");
        sb.append("{iSubReports=").append(this.iSubReports);
        sb.append('}');
        return sb.toString();
    }

    private class SSSubReport {
        private String iName;
        private JasperReport iReport;
        private JRDataSource iDataSource;
        private Map<String, Object> iParameters;
        private ResourceBundle iBundle;

        private SSSubReport() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.SSMultiPrinter.SSSubReport");
            sb.append("{iBundle=").append(this.iBundle);
            sb.append(", iDataSource=").append(this.iDataSource);
            sb.append(", iName='").append(this.iName).append('\'');
            sb.append(", iParameters=").append(this.iParameters);
            sb.append(", iReport=").append(this.iReport);
            sb.append('}');
            return sb.toString();
        }
    }
}

