/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.util.SSFilter;
import se.swedsoft.bookkeeping.calc.util.SSFilterFactory;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.customer.util.SSCustomerDropdownModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBoxOld;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;

public class SSInvoiceListDialog
extends SSDialog {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JRadioButton iRadioAll;
    private JRadioButton iRadioNotpayed;
    private JRadioButton iRadioExpired;
    private JCheckBox iCheckDate;
    private JCheckBox iCheckCustomer;
    private SSTableComboBoxOld<SSCustomer> iCustomer;
    private SSDateChooser iToDate;
    private SSDateChooser iFromDate;

    public SSInvoiceListDialog(SSMainFrame iMainFrame) {
        super(iMainFrame, SSBundle.getBundle().getString("invoicelistreport.dialog.title"));
        this.$$$setupUI$$$();
        this.setPanel(this.iPanel);
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoiceListDialog.this.setModalResult(2, true);
            }
        });
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoiceListDialog.this.setModalResult(0, true);
            }
        });
        this.iCustomer.setModel(new SSCustomerDropdownModel());
        this.iCustomer.setSearchColumns(0);
        this.iCustomer.setColumnWidths(60, 200);
        this.iCustomer.setPopupSize(250, 150);
        ChangeListener iChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSInvoiceListDialog.this.iCustomer.setEnabled(SSInvoiceListDialog.this.iCheckCustomer.isSelected());
                SSInvoiceListDialog.this.iFromDate.setEnabled(SSInvoiceListDialog.this.iCheckDate.isSelected());
                SSInvoiceListDialog.this.iToDate.setEnabled(SSInvoiceListDialog.this.iCheckDate.isSelected());
            }
        };
        this.iCheckDate.addChangeListener(iChangeListener);
        this.iCheckCustomer.addChangeListener(iChangeListener);
        ButtonGroup iGroup = new ButtonGroup();
        iGroup.add(this.iRadioAll);
        iGroup.add(this.iRadioNotpayed);
        iGroup.add(this.iRadioExpired);
        iChangeListener.stateChanged(null);
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public List<SSInvoice> getInvoicesToPrint() {
        final List<SSCustomer> iCustomers = SSDB.getInstance().getCustomers();
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        SSFilterFactory<SSInvoice> iFactory = new SSFilterFactory<SSInvoice>(iInvoices);
        if (this.iRadioNotpayed.isSelected()) {
            iFactory.applyFilter(new SSFilter<SSInvoice>(){

                @Override
                public boolean applyFilter(SSInvoice iInvoice) {
                    return SSInvoiceMath.getSaldo(iInvoice.getNumber()).signum() != 0;
                }
            });
        }
        if (this.iRadioExpired.isSelected()) {
            iFactory.applyFilter(new SSFilter<SSInvoice>(){

                @Override
                public boolean applyFilter(SSInvoice iInvoice) {
                    return SSInvoiceMath.getSaldo(iInvoice.getNumber()).signum() != 0 && SSInvoiceMath.expired(iInvoice);
                }
            });
        }
        if (this.iCheckCustomer.isSelected() && this.iCustomer.hasSelected()) {
            final SSCustomer iCustomer = this.iCustomer.getSelected();
            iFactory.applyFilter(new SSFilter<SSInvoice>(){

                @Override
                public boolean applyFilter(SSInvoice iInvoice) {
                    return iCustomer.equals(iInvoice.getCustomer(iCustomers));
                }
            });
        }
        if (this.iCheckDate.isSelected()) {
            final Date iDateFrom = this.iFromDate.getDate();
            final Date iDateTo = this.iToDate.getDate();
            iFactory.applyFilter(new SSFilter<SSInvoice>(){

                @Override
                public boolean applyFilter(SSInvoice iInvoice) {
                    return SSInvoiceMath.inPeriod(iInvoice, iDateFrom, iDateTo);
                }
            });
        }
        return iFactory.getObjects();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.dialog.SSInvoiceListDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCheckCustomer=").append(this.iCheckCustomer);
        sb.append(", iCheckDate=").append(this.iCheckDate);
        sb.append(", iCustomer=").append(this.iCustomer);
        sb.append(", iFromDate=").append(this.iFromDate);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iRadioAll=").append(this.iRadioAll);
        sb.append(", iRadioExpired=").append(this.iRadioExpired);
        sb.append(", iRadioNotpayed=").append(this.iRadioNotpayed);
        sb.append(", iToDate=").append(this.iToDate);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JRadioButton jRadioButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(7, 4, new Insets(4, 4, 4, 4), 2, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iRadioAll = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("book").getString("invoicelistreport.dialog.all"));
        jRadioButton3.setSelected(true);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iRadioNotpayed = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("book").getString("invoicelistreport.dialog.notpayed"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("date.separator"));
        jPanel2.add((Component)jLabel, new GridConstraints(5, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.iFromDate = sSDateChooser2 = new SSDateChooser();
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        sSDateChooser2.setFocusTraversalPolicyProvider(false);
        jPanel2.add((Component)sSDateChooser2, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        this.iToDate = sSDateChooser = new SSDateChooser();
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        sSDateChooser.setFocusTraversalPolicyProvider(false);
        jPanel2.add((Component)sSDateChooser, new GridConstraints(5, 3, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("invoicelistreport.dialog.description"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.iCheckCustomer = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("invoicelistreport.dialog.customer"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iCheckDate = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("invoicelistreport.dialog.date"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iRadioExpired = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("book").getString("invoicelistreport.dialog.expired"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        SSTableComboBoxOld sSTableComboBoxOld = new SSTableComboBoxOld();
        this.iCustomer = sSTableComboBoxOld;
        jPanel2.add(sSTableComboBoxOld, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

