/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.project.util.SSProjectTableModel;
import se.swedsoft.bookkeeping.gui.resultunit.util.SSResultUnitTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSAccountTableModel;

public class SSMainBookDialog
extends SSDialog {
    private JPanel iPanel;
    private SSDateChooser iFromDate;
    private SSDateChooser iToDate;
    private SSTableComboBox<SSAccount> iToAccount;
    private SSTableComboBox<SSAccount> iFromAccount;
    private SSButtonPanel iButtonPanel;
    private JCheckBox iCheckProject;
    private JCheckBox iCheckResultunit;
    private SSTableComboBox<SSNewProject> iProject;
    private SSTableComboBox<SSNewResultUnit> iResultunit;

    public SSMainBookDialog(SSMainFrame iMainFrame) {
        super(iMainFrame, SSBundle.getBundle().getString("mainbookreport.dialog.title"));
        this.$$$setupUI$$$();
        this.setPanel(this.iPanel);
        this.iProject.setModel(SSProjectTableModel.getDropDownModel());
        this.iResultunit.setModel(SSResultUnitTableModel.getDropDownModel());
        this.iFromAccount.setModel(SSAccountTableModel.getDropDownModel());
        this.iFromAccount.setSearchColumns(0);
        this.iToAccount.setModel(SSAccountTableModel.getDropDownModel());
        this.iToAccount.setSearchColumns(0);
        this.iFromAccount.setSelected(SSAccountMath.getFirstAccount(SSDB.getInstance().getAccounts()));
        this.iToAccount.setSelected(SSAccountMath.getLastAccount(SSDB.getInstance().getAccounts()));
        this.iCheckProject.addActionListener(this);
        this.iCheckResultunit.addActionListener(this);
        this.actionPerformed(null);
    }

    public void setDateFrom(Date pDateFrom) {
        this.iFromDate.setDate(pDateFrom);
    }

    public void setDateTo(Date pDateTo) {
        this.iToDate.setDate(pDateTo);
    }

    public SSAccount getAccountFrom() {
        return this.iFromAccount.getSelected();
    }

    public SSAccount getAccountTo() {
        return this.iToAccount.getSelected();
    }

    public Date getDateFrom() {
        return this.iFromDate.getDate();
    }

    public Date getDateTo() {
        return this.iToDate.getDate();
    }

    public SSNewProject getProject() {
        if (this.iCheckProject.isSelected()) {
            return this.iProject.getSelected();
        }
        return null;
    }

    public SSNewResultUnit getResultUnit() {
        if (this.iCheckResultunit.isSelected()) {
            return this.iResultunit.getSelected();
        }
        return null;
    }

    public boolean isProjectSelected() {
        return this.iCheckProject.isSelected();
    }

    public boolean isResultUnitSelected() {
        return this.iCheckResultunit.isSelected();
    }

    public void addOkActionListener(ActionListener l) {
        this.iButtonPanel.addOkActionListener(l);
    }

    public void addCancelActionListener(ActionListener l) {
        this.iButtonPanel.addCancelActionListener(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.iProject.setEnabled(this.iCheckProject.isSelected());
        this.iResultunit.setEnabled(this.iCheckResultunit.isSelected());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.dialog.SSMainBookDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCheckProject=").append(this.iCheckProject);
        sb.append(", iCheckResultunit=").append(this.iCheckResultunit);
        sb.append(", iFromAccount=").append(this.iFromAccount);
        sb.append(", iFromDate=").append(this.iFromDate);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iProject=").append(this.iProject);
        sb.append(", iResultunit=").append(this.iResultunit);
        sb.append(", iToAccount=").append(this.iToAccount);
        sb.append(", iToDate=").append(this.iToDate);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(6, 4, new Insets(4, 4, 4, 4), 4, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("date.separator"));
        jPanel2.add((Component)jLabel, new GridConstraints(3, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.iFromDate = sSDateChooser2 = new SSDateChooser();
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        sSDateChooser2.setFocusTraversalPolicyProvider(false);
        jPanel2.add((Component)sSDateChooser2, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        this.iToDate = sSDateChooser = new SSDateChooser();
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        ((Component)sSDateChooser).setEnabled(true);
        jPanel2.add((Component)sSDateChooser, new GridConstraints(4, 3, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("date.separator"));
        jPanel2.add((Component)jLabel2, new GridConstraints(4, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iToAccount = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(3, 3, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        SSTableComboBox sSTableComboBox2 = new SSTableComboBox();
        this.iFromAccount = sSTableComboBox2;
        jPanel2.add(sSTableComboBox2, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("mainbookreport.dialog.description"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("mainbookreport.dialog.account"));
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("mainbookreport.dialog.date"));
        jPanel2.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iCheckProject = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("mainbookreport.dialog.project"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iCheckResultunit = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("mainbookreport.dialog.resultunit"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        SSTableComboBox sSTableComboBox3 = new SSTableComboBox();
        this.iProject = sSTableComboBox3;
        jPanel2.add(sSTableComboBox3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        SSTableComboBox sSTableComboBox4 = new SSTableComboBox();
        this.iResultunit = sSTableComboBox4;
        jPanel2.add(sSTableComboBox4, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

