/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.calc.math.SSOrderMath;
import se.swedsoft.bookkeeping.calc.util.SSFilter;
import se.swedsoft.bookkeeping.calc.util.SSFilterFactory;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.customer.util.SSCustomerDropdownModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBoxOld;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;

public class SSOrderListDialog
extends SSDialog {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JRadioButton iRadioAll;
    private JRadioButton iRadioInvoice;
    private JCheckBox iCheckDate;
    private JCheckBox iCheckCustomer;
    private SSTableComboBoxOld<SSCustomer> iCustomer;
    private SSDateChooser iToDate;
    private SSDateChooser iFromDate;

    public SSOrderListDialog(SSMainFrame iMainFrame) {
        super(iMainFrame, SSBundle.getBundle().getString("orderlistreport.dialog.title"));
        this.$$$setupUI$$$();
        this.setPanel(this.iPanel);
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrderListDialog.this.setModalResult(2, true);
            }
        });
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrderListDialog.this.setModalResult(0, true);
            }
        });
        this.iCustomer.setModel(new SSCustomerDropdownModel());
        this.iCustomer.setSearchColumns(0);
        this.iCustomer.setColumnWidths(60, 200);
        this.iCustomer.setPopupSize(250, 150);
        ChangeListener iChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSOrderListDialog.this.iCustomer.setEnabled(SSOrderListDialog.this.iCheckCustomer.isSelected());
                SSOrderListDialog.this.iFromDate.setEnabled(SSOrderListDialog.this.iCheckDate.isSelected());
                SSOrderListDialog.this.iToDate.setEnabled(SSOrderListDialog.this.iCheckDate.isSelected());
            }
        };
        this.iCheckDate.addChangeListener(iChangeListener);
        this.iCheckCustomer.addChangeListener(iChangeListener);
        ButtonGroup iGroup = new ButtonGroup();
        iGroup.add(this.iRadioAll);
        iGroup.add(this.iRadioInvoice);
        iChangeListener.stateChanged(null);
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public List<SSOrder> getOrdersToPrint() {
        final List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        final List<SSCustomer> iCustomers = SSDB.getInstance().getCustomers();
        List<SSOrder> iOrders = SSDB.getInstance().getOrders();
        SSFilterFactory<SSOrder> iFactory = new SSFilterFactory<SSOrder>(iOrders);
        if (this.iRadioInvoice.isSelected()) {
            iFactory.applyFilter(new SSFilter<SSOrder>(){

                @Override
                public boolean applyFilter(SSOrder iOrder) {
                    return iOrder.getInvoice(iInvoices) == null;
                }
            });
        }
        if (this.iCheckCustomer.isSelected() && this.iCustomer.hasSelected()) {
            final SSCustomer iCustomer = this.iCustomer.getSelected();
            iFactory.applyFilter(new SSFilter<SSOrder>(){

                @Override
                public boolean applyFilter(SSOrder iOrder) {
                    return iCustomer.equals(iOrder.getCustomer(iCustomers));
                }
            });
        }
        if (this.iCheckDate.isSelected()) {
            final Date iDateFrom = this.iFromDate.getDate();
            final Date iDateTo = this.iToDate.getDate();
            iFactory.applyFilter(new SSFilter<SSOrder>(){

                @Override
                public boolean applyFilter(SSOrder iOrder) {
                    return SSOrderMath.inPeriod(iOrder, iDateFrom, iDateTo);
                }
            });
        }
        return iFactory.getObjects();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.dialog.SSOrderListDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCheckCustomer=").append(this.iCheckCustomer);
        sb.append(", iCheckDate=").append(this.iCheckDate);
        sb.append(", iCustomer=").append(this.iCustomer);
        sb.append(", iFromDate=").append(this.iFromDate);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iRadioAll=").append(this.iRadioAll);
        sb.append(", iRadioInvoice=").append(this.iRadioInvoice);
        sb.append(", iToDate=").append(this.iToDate);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(6, 4, new Insets(4, 4, 4, 4), 4, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iRadioAll = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("book").getString("orderlistreport.dialog.all"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iRadioInvoice = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("book").getString("orderlistreport.dialog.noinvoice"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("date.separator"));
        jPanel2.add((Component)jLabel, new GridConstraints(4, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.iFromDate = sSDateChooser2 = new SSDateChooser();
        sSDateChooser2.setFocusTraversalPolicyProvider(false);
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel2.add((Component)sSDateChooser2, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        this.iToDate = sSDateChooser = new SSDateChooser();
        sSDateChooser.setFocusTraversalPolicyProvider(false);
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel2.add((Component)sSDateChooser, new GridConstraints(4, 3, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        SSTableComboBoxOld sSTableComboBoxOld = new SSTableComboBoxOld();
        this.iCustomer = sSTableComboBoxOld;
        jPanel2.add(sSTableComboBoxOld, new GridConstraints(3, 1, 1, 3, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("orderlistreport.dialog.description"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.iCheckCustomer = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("orderlistreport.dialog.customer"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iCheckDate = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("orderlistreport.dialog.date"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

