/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSAccountTableModel;

public class SSVATReportDialog
extends SSDialog {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private SSDateChooser iTo;
    private SSDateChooser iFrom;
    private SSTableComboBox<SSAccount> iAccountA;
    private SSTableComboBox<SSAccount> iAccountR1;
    private SSTableComboBox<SSAccount> iAccountR2;
    private JTextField txtAccountR2;
    private JTextField txtAccountR1;
    private JTextField txtAccountA;

    public SSVATReportDialog(SSMainFrame iMainFrame) {
        super(iMainFrame, SSBundle.getBundle().getString("vatreport2007.dialog.title"));
        this.$$$setupUI$$$();
        this.setPanel(this.iPanel);
        this.iAccountA.setModel(SSAccountTableModel.getDropDownModel());
        this.iAccountA.setSearchColumns(0);
        this.iAccountA.setAllowCustomValues(false);
        this.iAccountR1.setModel(SSAccountTableModel.getDropDownModel());
        this.iAccountR1.setSearchColumns(0);
        this.iAccountR1.setAllowCustomValues(false);
        this.iAccountR2.setModel(SSAccountTableModel.getDropDownModel());
        this.iAccountR2.setSearchColumns(0);
        this.iAccountR2.setAllowCustomValues(false);
        this.iAccountR1.addSelectionListener(new SSSelectionListener<SSAccount>(){

            @Override
            public void selected(SSAccount selected) {
                SSVATReportDialog.this.txtAccountR1.setText(selected == null ? "" : selected.getDescription());
            }
        });
        this.iAccountR2.addSelectionListener(new SSSelectionListener<SSAccount>(){

            @Override
            public void selected(SSAccount selected) {
                SSVATReportDialog.this.txtAccountR2.setText(selected == null ? "" : selected.getDescription());
            }
        });
        this.iAccountA.addSelectionListener(new SSSelectionListener<SSAccount>(){

            @Override
            public void selected(SSAccount selected) {
                SSVATReportDialog.this.txtAccountA.setText(selected == null ? "" : selected.getDescription());
            }
        });
        this.iAccountR1.setSelected(SSAccountMath.getAccountWithVATCode(SSDB.getInstance().getAccounts(), "R1", new SSAccount(1650)), true);
        this.iAccountR2.setSelected(SSAccountMath.getAccountWithVATCode(SSDB.getInstance().getAccounts(), "R2", new SSAccount(2650)), true);
        this.iAccountA.setSelected(SSAccountMath.getAccountWithVATCode(SSDB.getInstance().getAccounts(), "A", new SSAccount(3740)), true);
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVATReportDialog.this.setModalResult(2, true);
            }
        });
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVATReportDialog.this.setModalResult(0, true);
            }
        });
        SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
        Calendar iCalendar = Calendar.getInstance();
        if (iCurrentCompany.getVatPeriod() != null && iCurrentCompany.getVatPeriod() != 0) {
            iCalendar.add(2, iCurrentCompany.getVatPeriod() * -1);
        } else {
            iCalendar.add(2, -1);
        }
        iCalendar.set(5, iCalendar.getActualMinimum(5));
        this.iFrom.setDate(iCalendar.getTime());
        iCalendar = Calendar.getInstance();
        iCalendar.add(2, -1);
        iCalendar.set(5, iCalendar.getActualMaximum(5));
        this.iTo.setDate(iCalendar.getTime());
    }

    public Date getTo() {
        return this.iTo.getDate();
    }

    public void setTo(Date to) {
        this.iTo.setDate(to);
    }

    public Date getFrom() {
        return this.iFrom.getDate();
    }

    public void setFrom(Date from) {
        this.iFrom.setDate(from);
    }

    public SSAccount getAccountR1() {
        return this.iAccountR1.getSelected();
    }

    public SSAccount getAccountR2() {
        return this.iAccountR2.getSelected();
    }

    public SSAccount getAccountA() {
        return this.iAccountA.getSelected();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.dialog.SSVATReportDialog");
        sb.append("{iAccountA=").append(this.iAccountA);
        sb.append(", iAccountR1=").append(this.iAccountR1);
        sb.append(", iAccountR2=").append(this.iAccountR2);
        sb.append(", iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iFrom=").append(this.iFrom);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iTo=").append(this.iTo);
        sb.append(", txtAccountA=").append(this.txtAccountA);
        sb.append(", txtAccountR1=").append(this.txtAccountR1);
        sb.append(", txtAccountR2=").append(this.txtAccountR2);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(4, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 3, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("book").getString("vatreport2007.dialog.date"), 0, 0, null, null));
        this.iFrom = sSDateChooser2 = new SSDateChooser();
        jPanel2.add((Component)sSDateChooser2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("date.separator"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTo = sSDateChooser = new SSDateChooser();
        jPanel2.add((Component)sSDateChooser, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 3, null, new Dimension(160, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 3, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("book").getString("vatreport2007.dialog.accounts"), 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("vatreport2007.dialog.accountR2"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iAccountR1 = sSTableComboBox;
        jPanel3.add(sSTableComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        SSTableComboBox sSTableComboBox2 = new SSTableComboBox();
        this.iAccountR2 = sSTableComboBox2;
        jPanel3.add(sSTableComboBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        SSTableComboBox sSTableComboBox3 = new SSTableComboBox();
        this.iAccountA = sSTableComboBox3;
        jPanel3.add(sSTableComboBox3, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("vatreport2007.dialog.accountA"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.txtAccountR1 = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.txtAccountR2 = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel3.add((Component)jTextField2, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.txtAccountA = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel3.add((Component)jTextField, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("vatreport2007.dialog.accountR1"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

