/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.calc.util.SSFilter;
import se.swedsoft.bookkeeping.calc.util.SSFilterFactory;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherTableModel;

public class SSVoucherListDialog
extends SSDialog {
    private JPanel iPanel;
    private SSDateChooser iFromDate;
    private SSDateChooser iToDate;
    private SSTableComboBox<SSVoucher> iToVoucher;
    private SSTableComboBox<SSVoucher> iFromVoucher;
    private JRadioButton iRadioNumber;
    private JRadioButton iRadioDate;
    private JRadioButton iRadioAll;
    private SSButtonPanel iButtonPanel;

    public SSVoucherListDialog(SSMainFrame iMainFrame) {
        super(iMainFrame, SSBundle.getBundle().getString("voucherlistreport.dialog.title"));
        this.$$$setupUI$$$();
        List<SSVoucher> iVouchers = SSDB.getInstance().getCurrentYear().getVouchers();
        this.setPanel(this.iPanel);
        ButtonGroup iButtonGroup = new ButtonGroup();
        iButtonGroup.add(this.iRadioNumber);
        iButtonGroup.add(this.iRadioDate);
        iButtonGroup.add(this.iRadioAll);
        ChangeListener iChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSVoucherListDialog.this.iFromVoucher.setEnabled(SSVoucherListDialog.this.iRadioNumber.isSelected());
                SSVoucherListDialog.this.iToVoucher.setEnabled(SSVoucherListDialog.this.iRadioNumber.isSelected());
                SSVoucherListDialog.this.iFromDate.setEnabled(SSVoucherListDialog.this.iRadioDate.isSelected());
                SSVoucherListDialog.this.iToDate.setEnabled(SSVoucherListDialog.this.iRadioDate.isSelected());
            }
        };
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherListDialog.this.closeDialog(0);
            }
        });
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherListDialog.this.closeDialog(2);
            }
        });
        this.iRadioAll.addChangeListener(iChangeListener);
        this.iRadioDate.addChangeListener(iChangeListener);
        this.iRadioNumber.addChangeListener(iChangeListener);
        this.iFromVoucher.setModel(SSVoucherTableModel.getDropDownModel());
        this.iToVoucher.setModel(SSVoucherTableModel.getDropDownModel());
        this.iFromVoucher.setSelected(SSVoucherMath.getFirst(iVouchers));
        this.iToVoucher.setSelected(SSVoucherMath.getLast(iVouchers));
        this.iFromVoucher.setSearchColumns(0);
        this.iToVoucher.setSearchColumns(0);
        this.iRadioAll.setSelected(true);
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public SSVoucherRange getVoucherRange() {
        if (this.iRadioNumber.isSelected()) {
            return SSVoucherRange.BETWEEN_NUMBER;
        }
        if (this.iRadioDate.isSelected()) {
            return SSVoucherRange.BETWEEN_DATE;
        }
        return SSVoucherRange.ALL_VOUCHERS;
    }

    public void setDateFrom(Date pDateFrom) {
        this.iFromDate.setDate(pDateFrom);
    }

    public void setDateTo(Date pDateTo) {
        this.iToDate.setDate(pDateTo);
    }

    public Integer getNumberFrom() {
        SSVoucher iSelected = this.iFromVoucher.getSelected();
        return iSelected == null ? 0 : iSelected.getNumber();
    }

    public Integer getNumberTo() {
        SSVoucher iSelected = this.iToVoucher.getSelected();
        return iSelected == null ? 0 : iSelected.getNumber();
    }

    public Date getDateFrom() {
        return this.iFromDate.getDate();
    }

    public Date getDateTo() {
        return this.iToDate.getDate();
    }

    public boolean isNumberSelected() {
        return this.iRadioNumber.isSelected();
    }

    public boolean isDateSelected() {
        return this.iRadioDate.isSelected();
    }

    public List<SSVoucher> getElementsToPrint() {
        List<SSVoucher> iVouchers = SSDB.getInstance().getVouchers();
        if (this.iRadioNumber.isSelected()) {
            final Integer iNumberFrom = this.iFromVoucher.getSelected().getNumber();
            final Integer iNumberTo = this.iToVoucher.getSelected().getNumber();
            iVouchers = SSFilterFactory.doFilter(iVouchers, new SSFilter<SSVoucher>(){

                @Override
                public boolean applyFilter(SSVoucher iObject) {
                    Integer iNumber = iObject.getNumber();
                    return iNumber >= iNumberFrom && iNumber <= iNumberTo;
                }
            });
        }
        if (this.iRadioDate.isSelected()) {
            final Date iDateFrom = this.iFromDate.getDate();
            final Date iDateTo = this.iToDate.getDate();
            iVouchers = SSFilterFactory.doFilter(iVouchers, new SSFilter<SSVoucher>(){

                @Override
                public boolean applyFilter(SSVoucher iInvoice) {
                    return SSVoucherMath.inPeriod(iInvoice, iDateFrom, iDateTo);
                }
            });
        }
        return iVouchers;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.dialog.SSVoucherListDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iFromDate=").append(this.iFromDate);
        sb.append(", iFromVoucher=").append(this.iFromVoucher);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iRadioAll=").append(this.iRadioAll);
        sb.append(", iRadioDate=").append(this.iRadioDate);
        sb.append(", iRadioNumber=").append(this.iRadioNumber);
        sb.append(", iToDate=").append(this.iToDate);
        sb.append(", iToVoucher=").append(this.iToVoucher);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(6, 4, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iRadioAll = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("book").getString("voucherlistreport.dialog.filter.all"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iRadioNumber = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("book").getString("voucherlistreport.dialog.number"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iRadioDate = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("book").getString("voucherlistreport.dialog.date"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("voucherlistreport.dialog.message"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("date.separator"));
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.iFromDate = sSDateChooser2 = new SSDateChooser();
        sSDateChooser2.setFocusTraversalPolicyProvider(false);
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel2.add((Component)sSDateChooser2, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, new Dimension(120, -1), null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("date.separator"));
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.iToDate = sSDateChooser = new SSDateChooser();
        ((Component)sSDateChooser).setEnabled(true);
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel2.add((Component)sSDateChooser, new GridConstraints(3, 3, 1, 1, 8, 0, 3, 3, new Dimension(120, -1), null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iFromVoucher = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        SSTableComboBox sSTableComboBox2 = new SSTableComboBox();
        this.iToVoucher = sSTableComboBox2;
        jPanel2.add(sSTableComboBox2, new GridConstraints(2, 3, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static enum SSVoucherRange {
        ALL_VOUCHERS,
        BETWEEN_NUMBER,
        BETWEEN_DATE;

    }
}

