/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.SSBalanceCalculator;
import se.swedsoft.bookkeeping.calc.data.SSAccountGroup;
import se.swedsoft.bookkeeping.calc.data.SSAccountSchema;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSBalancePrinter
extends SSPrinter {
    SSNewAccountingYear iYearData;
    SSAccountSchema iAccountSchema;
    Date iDateFrom;
    Date iDateTo;

    public SSBalancePrinter(Date pFrom, Date pTo) {
        this(SSDB.getInstance().getCurrentYear(), pFrom, pTo);
    }

    public SSBalancePrinter(SSNewAccountingYear pYearData, Date pFrom, Date pTo) {
        this.iYearData = pYearData;
        this.iDateFrom = pFrom;
        this.iDateTo = pTo;
        this.iAccountSchema = SSAccountSchema.getAccountSchema(pYearData);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("balance.jrxml");
        this.setDetail("balance.jrxml");
        this.setSummary("balance.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("balancereport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        SSBalanceCalculator iCalculator = new SSBalanceCalculator(this.iYearData);
        iCalculator.calculate(this.iDateFrom, this.iDateTo);
        final Map<SSAccount, BigDecimal> iInBalance = iCalculator.getInBalance();
        final Map<SSAccount, BigDecimal> iInSaldo = iCalculator.getInSaldo();
        final Map<SSAccount, BigDecimal> iPeriodChange = iCalculator.getPeriodChange();
        final Map<SSAccount, BigDecimal> iOutSaldo = iCalculator.getOutSaldo();
        List<SSAccountGroup> iBalanceGroups = this.iAccountSchema.getBalanceGroups();
        List<SSAccount> iAccounts = this.iYearData.getAccounts();
        LinkedList<BalanceRow> iRows = new LinkedList<BalanceRow>();
        for (SSAccountGroup iBalanceGroup : iBalanceGroups) {
            List<BalanceRow> iCurrentRows = this.getRows(iBalanceGroup, iAccounts, 0);
            for (BalanceRow iRow : iCurrentRows) {
                SSAccount iAccount = iRow.iAccount;
                if (!iInBalance.containsKey(iAccount) && !iInSaldo.containsKey(iAccount) && !iPeriodChange.containsKey(iAccount) && !iOutSaldo.containsKey(iAccount)) continue;
                iRows.add(iRow);
            }
        }
        SSDefaultTableModel<BalanceRow> iModel = new SSDefaultTableModel<BalanceRow>(){

            @Override
            public Class getType() {
                return BalanceRow.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                BalanceRow iRow = (BalanceRow)this.getObject(rowIndex);
                SSAccount iAccount = iRow.iAccount;
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iAccount.getNumber();
                        break;
                    }
                    case 1: {
                        value = iAccount.getDescription();
                        break;
                    }
                    case 2: {
                        value = iInBalance.get(iAccount);
                        if (value != null) break;
                        value = new BigDecimal(0);
                        break;
                    }
                    case 3: {
                        value = iInSaldo.get(iAccount);
                        if (value != null) break;
                        value = new BigDecimal(0);
                        break;
                    }
                    case 4: {
                        value = iPeriodChange.get(iAccount);
                        if (value != null) break;
                        value = new BigDecimal(0);
                        break;
                    }
                    case 5: {
                        value = iOutSaldo.get(iAccount);
                        if (value != null) break;
                        value = new BigDecimal(0);
                        break;
                    }
                    case 6: {
                        value = iRow.getLevelGroup(0);
                        break;
                    }
                    case 7: {
                        value = iRow.getLevelGroup(1);
                        break;
                    }
                    case 8: {
                        value = iRow.getLevelGroup(2);
                        break;
                    }
                    case 9: {
                        value = iRow.iLevelGroups[0] != null ? iRow.iLevelGroups[0].getTitle() : null;
                        break;
                    }
                    case 10: {
                        value = iRow.iLevelGroups[1] != null ? iRow.iLevelGroups[1].getTitle() : null;
                        break;
                    }
                    case 11: {
                        value = iRow.iLevelGroups[2] != null ? iRow.iLevelGroups[2].getTitle() : null;
                        break;
                    }
                    case 12: {
                        value = iRow.iLevelGroups[0] != null ? iRow.iLevelGroups[0].getSumTitle() : null;
                        break;
                    }
                    case 13: {
                        value = iRow.iLevelGroups[1] != null ? iRow.iLevelGroups[1].getSumTitle() : null;
                        break;
                    }
                    case 14: {
                        value = iRow.iLevelGroups[2] != null ? iRow.iLevelGroups[2].getSumTitle() : null;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("account.number");
        iModel.addColumn("account.description");
        iModel.addColumn("account.inBalance");
        iModel.addColumn("account.inSaldo");
        iModel.addColumn("account.change");
        iModel.addColumn("account.outSaldo");
        iModel.addColumn("account.group.1");
        iModel.addColumn("account.group.2");
        iModel.addColumn("account.group.3");
        iModel.addColumn("group.1.title");
        iModel.addColumn("group.2.title");
        iModel.addColumn("group.3.title");
        iModel.addColumn("group.1.sumtitle");
        iModel.addColumn("group.2.sumtitle");
        iModel.addColumn("group.3.sumtitle");
        iModel.setObjects((List<BalanceRow>)iRows);
        return iModel;
    }

    private List<BalanceRow> getRows(SSAccountGroup iGroup, List<SSAccount> iAccounts, int iLevel) {
        List<SSAccount> iGroupAccounts = iGroup.getGroupAccounts(iAccounts);
        LinkedList<BalanceRow> iRows = new LinkedList<BalanceRow>();
        if (iGroup.getGroups() == null) {
            for (SSAccount iAccount : iGroupAccounts) {
                BalanceRow iRow = new BalanceRow();
                iRow.iAccount = iAccount;
                iRow.iLevelGroups[iLevel] = iGroup;
                iRows.add(iRow);
            }
        } else {
            for (SSAccountGroup iBalanceGroup : iGroup.getGroups()) {
                iRows.addAll(this.getRows(iBalanceGroup, iAccounts, iLevel + 1));
            }
            for (BalanceRow iRow : iRows) {
                iRow.iLevelGroups[iLevel] = iGroup;
            }
        }
        return iRows;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSBalancePrinter");
        sb.append("{iAccountSchema=").append(this.iAccountSchema);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iYearData=").append(this.iYearData);
        sb.append('}');
        return sb.toString();
    }

    private class BalanceRow {
        SSAccount iAccount;
        SSAccountGroup[] iLevelGroups = new SSAccountGroup[3];

        private BalanceRow() {
        }

        public int getLevelGroup(int iLevel) {
            if (this.iLevelGroups[iLevel] == null) {
                return -1;
            }
            return this.iLevelGroups[iLevel].getId();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSBalancePrinter.BalanceRow");
            sb.append("{iAccount=").append(this.iAccount);
            sb.append(", iLevelGroups=").append(this.iLevelGroups == null ? "null" : Arrays.asList(this.iLevelGroups).toString());
            sb.append('}');
            return sb.toString();
        }
    }
}

