/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSBudget;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSBudgetPrinter
extends SSPrinter {
    private SSMonthlyDistributionPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private SSNewAccountingYear iAccountingYear;
    private Date iDateFrom;
    private Date iDateTo;

    public SSBudgetPrinter() {
        this(SSDB.getInstance().getCurrentYear());
    }

    public SSBudgetPrinter(Date pFrom, Date pTo) {
        this(SSDB.getInstance().getCurrentYear(), pFrom, pTo);
    }

    public SSBudgetPrinter(SSNewAccountingYear pAccountingYear) {
        this(pAccountingYear, pAccountingYear.getFrom(), pAccountingYear.getTo());
    }

    public SSBudgetPrinter(SSNewAccountingYear pAccountingYear, Date pFrom, Date pTo) {
        this.iAccountingYear = pAccountingYear;
        this.iDateFrom = pFrom;
        this.iDateTo = pTo;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("budget.jrxml");
        this.setDetail("budget.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("budgetreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        this.iPrinter = new SSMonthlyDistributionPrinter(this.iAccountingYear, this.iDateFrom, this.iDateTo);
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        final SSBudget iBudget = this.iAccountingYear.getBudget();
        List<SSAccount> iAccounts = SSAccountMath.getResultAccounts(this.iAccountingYear, this.iAccountingYear.getAccounts());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSAccount> iModel = new SSDefaultTableModel<SSAccount>(){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSAccount iAccount = (SSAccount)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iAccount.getNumber();
                        break;
                    }
                    case 1: {
                        value = iAccount.getDescription();
                        break;
                    }
                    case 2: {
                        value = iBudget.getSumForAccount(iAccount) != null;
                        break;
                    }
                    case 3: {
                        SSBudgetPrinter.this.iPrinter.setAccount(iAccount);
                        SSBudgetPrinter.this.iDataSource.reset();
                        value = SSBudgetPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("account.number");
        iModel.addColumn("account.description");
        iModel.addColumn("account.visible");
        iModel.addColumn("month.data");
        Collections.sort(iAccounts, new Comparator<SSAccount>(){

            @Override
            public int compare(SSAccount o1, SSAccount o2) {
                return SSAccountMath.getResultGroup(o1, SSBudgetPrinter.this.iAccountingYear) - SSAccountMath.getResultGroup(o2, SSBudgetPrinter.this.iAccountingYear);
            }
        });
        iModel.setObjects(iAccounts);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSBudgetPrinter");
        sb.append("{iAccountingYear=").append(this.iAccountingYear);
        sb.append(", iDataSource=").append(this.iDataSource);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSMonthlyDistributionPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSMonth> iModel;
        private SSAccount iAccount;
        private Date iFrom;
        private Date iTo;

        public SSMonthlyDistributionPrinter(SSNewAccountingYear pAccountingYear, Date pFrom, Date pTo) {
            this.iFrom = pFrom;
            this.iTo = pTo;
            this.setMargins(0, 0, 0, 0);
            this.setDetail("budget.monthly.jrxml");
            this.setSummary("budget.monthly.jrxml");
            final SSBudget iBudget = pAccountingYear.getBudget();
            this.iModel = new SSDefaultTableModel<SSMonth>(iBudget.getMonths()){

                @Override
                public Class getType() {
                    return SSMonth.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSMonth iMonth = (SSMonth)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iMonth.toString();
                            break;
                        }
                        case 1: {
                            value = iMonth.getName();
                            break;
                        }
                        case 2: {
                            value = iBudget.getValueForAccountAndMonth(SSMonthlyDistributionPrinter.this.iAccount, iMonth);
                            break;
                        }
                        case 3: {
                            value = iMonth.isBetween(SSMonthlyDistributionPrinter.this.iFrom, SSMonthlyDistributionPrinter.this.iTo);
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("month.date");
            this.iModel.addColumn("month.description");
            this.iModel.addColumn("month.value");
            this.iModel.addColumn("month.visible");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setAccount(SSAccount pAccount) {
            this.iAccount = pAccount;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSBudgetPrinter.SSMonthlyDistributionPrinter");
            sb.append("{iAccount=").append(this.iAccount);
            sb.append(", iFrom=").append(this.iFrom);
            sb.append(", iModel=").append(this.iModel);
            sb.append(", iTo=").append(this.iTo);
            sb.append('}');
            return sb.toString();
        }
    }
}

