/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSCustomerListPrinter
extends SSPrinter {
    private List<SSCustomer> iCustomers;

    public SSCustomerListPrinter() {
        this(SSDB.getInstance().getCustomers());
    }

    public SSCustomerListPrinter(List<SSCustomer> iCustomers) {
        this.iCustomers = iCustomers;
        this.setPageHeader("header.jrxml");
        this.setColumnHeader("customerlist.jrxml");
        this.setDetail("customerlist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("customerlistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        SSDefaultTableModel<SSCustomer> iModel = new SSDefaultTableModel<SSCustomer>(){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String value = null;
                SSCustomer iCustomer = (SSCustomer)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iCustomer.getNumber();
                        break;
                    }
                    case 1: {
                        value = iCustomer.getName();
                        break;
                    }
                    case 2: {
                        value = iCustomer.getYourContactPerson();
                        break;
                    }
                    case 3: {
                        value = iCustomer.getRegistrationNumber();
                        break;
                    }
                    case 4: {
                        value = iCustomer.getPhone1();
                        break;
                    }
                    case 5: {
                        value = iCustomer.getTelefax();
                    }
                }
                return value;
            }
        };
        iModel.addColumn("customer.number");
        iModel.addColumn("customer.name");
        iModel.addColumn("customer.contact");
        iModel.addColumn("customer.registrationnumber");
        iModel.addColumn("customer.phone");
        iModel.addColumn("customer.telefax");
        Collections.sort(this.iCustomers, new Comparator<SSCustomer>(){

            @Override
            public int compare(SSCustomer o1, SSCustomer o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        iModel.setObjects(this.iCustomers);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSCustomerListPrinter");
        sb.append("{iCustomers=").append(this.iCustomers);
        sb.append('}');
        return sb.toString();
    }
}

