/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSCustomerRevenuePrinter
extends SSPrinter {
    private SSMonthlyDistributionPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSCustomer> iCustomers;
    private Date iDateFrom;
    private Date iDateTo;
    Map<String, Map<SSMonth, BigDecimal>> iCustomerRevenue;

    public SSCustomerRevenuePrinter(List<SSCustomer> pCustomers, Date pFrom, Date pTo) {
        this.iCustomers = pCustomers;
        this.iDateFrom = SSDateMath.floor(pFrom);
        this.iDateTo = SSDateMath.ceil(pTo);
        this.calculate();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("customerrevenue.jrxml");
        this.setDetail("customerrevenue.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("customerrevenue.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        this.iPrinter = new SSMonthlyDistributionPrinter(this.iDateFrom, this.iDateTo);
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSCustomer> iModel = new SSDefaultTableModel<SSCustomer>(){

            @Override
            public Class getType() {
                return SSCustomer.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSCustomer iCustomer = (SSCustomer)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iCustomer.getNumber();
                        break;
                    }
                    case 1: {
                        value = iCustomer.getName();
                        break;
                    }
                    case 2: {
                        SSCustomerRevenuePrinter.this.iPrinter.setCustomer(iCustomer, SSCustomerRevenuePrinter.this.iCustomerRevenue.get(iCustomer.getNumber()));
                        SSCustomerRevenuePrinter.this.iDataSource.reset();
                        value = SSCustomerRevenuePrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("customer.number");
        iModel.addColumn("customer.description");
        iModel.addColumn("month.data");
        iModel.setObjects(this.iCustomers);
        return iModel;
    }

    private void calculate() {
        this.iCustomerRevenue = new HashMap<String, Map<SSMonth, BigDecimal>>();
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInvoice iInvoice : iInvoices) {
            Map<Object, Object> iRevenueInMonth;
            if (!iInvoice.getDate().after(this.iDateFrom) || !iInvoice.getDate().before(this.iDateTo)) continue;
            Calendar iCal = Calendar.getInstance();
            iCal.setTime(iInvoice.getDate());
            iCal.set(5, 1);
            Date iFrom = iCal.getTime();
            iCal.set(5, iCal.getActualMaximum(5));
            Date iTo = iCal.getTime();
            SSMonth iMonth = new SSMonth(iFrom, iTo);
            if (iInvoice.getCustomerNr() == null || SSInvoiceMath.getNetSum(iInvoice) == null) continue;
            BigDecimal iSum = SSInvoiceMath.convertToLocal(iInvoice, SSInvoiceMath.getNetSum(iInvoice));
            if (this.iCustomerRevenue.containsKey(iInvoice.getCustomerNr())) {
                iRevenueInMonth = this.iCustomerRevenue.get(iInvoice.getCustomerNr());
                if (iRevenueInMonth.containsKey(iMonth)) {
                    iRevenueInMonth.put(iMonth, ((BigDecimal)iRevenueInMonth.get(iMonth)).add(iSum));
                } else {
                    iRevenueInMonth.put(iMonth, iSum);
                }
            } else {
                iRevenueInMonth = new HashMap<SSMonth, BigDecimal>();
                iRevenueInMonth.put(iMonth, iSum);
            }
            this.iCustomerRevenue.put(iInvoice.getCustomerNr(), iRevenueInMonth);
        }
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            Map<Object, Object> iRevenueInMonth;
            if (!iCreditInvoice.getDate().after(this.iDateFrom) || !iCreditInvoice.getDate().before(this.iDateTo)) continue;
            Calendar iCal = Calendar.getInstance();
            iCal.setTime(iCreditInvoice.getDate());
            iCal.set(5, 1);
            Date iFrom = iCal.getTime();
            iCal.set(5, iCal.getActualMaximum(5));
            Date iTo = iCal.getTime();
            SSMonth iMonth = new SSMonth(iFrom, iTo);
            if (iCreditInvoice.getCustomerNr() == null || SSCreditInvoiceMath.getNetSum(iCreditInvoice) == null) continue;
            BigDecimal iSum = SSCreditInvoiceMath.convertToLocal(iCreditInvoice, SSCreditInvoiceMath.getNetSum(iCreditInvoice));
            if (this.iCustomerRevenue.containsKey(iCreditInvoice.getCustomerNr())) {
                iRevenueInMonth = this.iCustomerRevenue.get(iCreditInvoice.getCustomerNr());
                if (iRevenueInMonth.containsKey(iMonth)) {
                    iRevenueInMonth.put(iMonth, ((BigDecimal)iRevenueInMonth.get(iMonth)).subtract(iSum));
                } else {
                    iRevenueInMonth.put(iMonth, iSum.negate());
                }
            } else {
                iRevenueInMonth = new HashMap<SSMonth, BigDecimal>();
                iRevenueInMonth.put(iMonth, iSum.negate());
            }
            this.iCustomerRevenue.put(iCreditInvoice.getCustomerNr(), iRevenueInMonth);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSCustomerRevenuePrinter");
        sb.append("{iCustomerRevenue=").append(this.iCustomerRevenue);
        sb.append(", iCustomers=").append(this.iCustomers);
        sb.append(", iDataSource=").append(this.iDataSource);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSMonthlyDistributionPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSMonth> iModel;
        private SSCustomer iCustomer;
        private Date iFrom;
        private Date iTo;
        Map<SSMonth, BigDecimal> iRevenue;

        public SSMonthlyDistributionPrinter(Date pFrom, Date pTo) {
            this.iFrom = pFrom;
            this.iTo = pTo;
            this.setMargins(0, 0, 0, 0);
            this.setDetail("customerrevenue.monthly.jrxml");
            this.setSummary("customerrevenue.monthly.jrxml");
            this.iModel = new SSDefaultTableModel<SSMonth>(SSMonth.splitYearIntoMonths(this.iFrom, this.iTo)){

                @Override
                public Class getType() {
                    return SSMonth.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSMonth iMonth = (SSMonth)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iMonth.toString();
                            break;
                        }
                        case 1: {
                            value = iMonth.getName();
                            break;
                        }
                        case 2: {
                            if (SSMonthlyDistributionPrinter.this.iCustomer != null && SSMonthlyDistributionPrinter.this.iRevenue.containsKey(iMonth)) {
                                value = SSMonthlyDistributionPrinter.this.iRevenue.get(iMonth);
                                break;
                            }
                            value = new BigDecimal(0);
                            break;
                        }
                        case 3: {
                            value = iMonth.isBetween(SSMonthlyDistributionPrinter.this.iFrom, SSMonthlyDistributionPrinter.this.iTo);
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("month.date");
            this.iModel.addColumn("month.description");
            this.iModel.addColumn("month.value");
            this.iModel.addColumn("month.visible");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setCustomer(SSCustomer pCustomer, Map<SSMonth, BigDecimal> iMap) {
            this.iCustomer = pCustomer;
            this.iRevenue = iMap;
            if (this.iRevenue == null) {
                this.iRevenue = new HashMap<SSMonth, BigDecimal>();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSCustomerRevenuePrinter.SSMonthlyDistributionPrinter");
            sb.append("{iCustomer=").append(this.iCustomer);
            sb.append(", iFrom=").append(this.iFrom);
            sb.append(", iModel=").append(this.iModel);
            sb.append(", iRevenue=").append(this.iRevenue);
            sb.append(", iTo=").append(this.iTo);
            sb.append('}');
            return sb.toString();
        }
    }
}

