/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSCustomerclaimPrinter
extends SSPrinter {
    private Map<SSInvoice, BigDecimal> iSaldos;

    public SSCustomerclaimPrinter(Date iDate) {
        this(iDate, SSDB.getInstance().getInvoices());
    }

    public SSCustomerclaimPrinter(Date iDate, List<SSInvoice> iInvoices) {
        this.iSaldos = SSInvoiceMath.getSaldo(iInvoices, iDate);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("customerclaim.jrxml");
        this.setDetail("customerclaim.jrxml");
        this.setSummary("customerclaim.jrxml");
        this.addParameter("periodTitle", this.iBundle.getString("customerclaimreport.periodtitle"));
        this.addParameter("periodText", iDate);
    }

    @Override
    public String getTitle() {
        return this.iBundle.getString("customerclaimreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        LinkedList<SSInvoice> iInvoices = new LinkedList<SSInvoice>(this.iSaldos.keySet());
        Collections.sort(iInvoices, new Comparator<SSInvoice>(){

            @Override
            public int compare(SSInvoice o1, SSInvoice o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        SSDefaultTableModel<SSInvoice> iModel = new SSDefaultTableModel<SSInvoice>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSInvoice iInvoice = (SSInvoice)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iInvoice.getNumber();
                        break;
                    }
                    case 1: {
                        value = iInvoice.getCustomerNr();
                        break;
                    }
                    case 2: {
                        value = iInvoice.getCustomerName();
                        break;
                    }
                    case 3: {
                        value = iInvoice.getDate() == null ? null : this.iFormat.format(iInvoice.getDate());
                        break;
                    }
                    case 4: {
                        value = iInvoice.getCurrency() == null ? null : iInvoice.getCurrency().getName();
                        break;
                    }
                    case 5: {
                        value = SSInvoiceMath.getTotalSum(iInvoice);
                        break;
                    }
                    case 6: {
                        value = SSCustomerclaimPrinter.this.iSaldos.get(iInvoice);
                        break;
                    }
                    case 7: {
                        BigDecimal iSaldo = (BigDecimal)SSCustomerclaimPrinter.this.iSaldos.get(iInvoice);
                        value = SSInvoiceMath.convertToLocal(iInvoice, iSaldo);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("invoice.number");
        iModel.addColumn("customer.number");
        iModel.addColumn("customer.name");
        iModel.addColumn("invoice.date");
        iModel.addColumn("invoice.currency");
        iModel.addColumn("invoice.sum");
        iModel.addColumn("invoice.saldo");
        iModel.addColumn("invoice.localsaldo");
        iModel.setObjects((List<SSInvoice>)iInvoices);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSCustomerclaimPrinter");
        sb.append("{iSaldos=").append(this.iSaldos);
        sb.append('}');
        return sb.toString();
    }
}

