/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSIndelivery;
import se.swedsoft.bookkeeping.data.SSIndeliveryRow;
import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSIndeliveryListPrinter
extends SSPrinter {
    private SSInventoryRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSIndelivery> iIndeliveries;

    public SSIndeliveryListPrinter() {
        this(SSDB.getInstance().getIndeliveries());
    }

    public SSIndeliveryListPrinter(List<SSIndelivery> iIndeliveries) {
        this.iIndeliveries = iIndeliveries;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("indeliverylist.jrxml");
        this.setDetail("indeliverylist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("indeliverylistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSInventoryRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSIndelivery> iModel = new SSDefaultTableModel<SSIndelivery>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInventory.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSIndelivery iIndelivery = (SSIndelivery)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iIndelivery.getNumber();
                        break;
                    }
                    case 1: {
                        value = this.iFormat.format(iIndelivery.getDate());
                        break;
                    }
                    case 2: {
                        value = iIndelivery.getText();
                        break;
                    }
                    case 3: {
                        SSIndeliveryListPrinter.this.iPrinter.setIndelivery(iIndelivery);
                        SSIndeliveryListPrinter.this.iDataSource.reset();
                        value = SSIndeliveryListPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("indelivery.number");
        iModel.addColumn("indelivery.date");
        iModel.addColumn("indelivery.text");
        iModel.addColumn("indelivery.rows");
        Collections.sort(this.iIndeliveries, new Comparator<SSIndelivery>(){

            @Override
            public int compare(SSIndelivery o1, SSIndelivery o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iIndeliveries);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSIndeliveryListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iIndeliveries=").append(this.iIndeliveries);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSInventoryRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSIndeliveryRow> iModel;

        public SSInventoryRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("indeliverylist.row.jrxml");
            this.setSummary("indeliverylist.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSIndeliveryRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSIndeliveryRow iRow = (SSIndeliveryRow)this.getObject(rowIndex);
                    SSProduct iProduct = iRow.getProduct();
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iProduct == null ? null : iProduct.getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getChange();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("indeliveryrow.product");
            this.iModel.addColumn("indeliveryrow.descripion");
            this.iModel.addColumn("indeliveryrow.change");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setIndelivery(SSIndelivery iIndelivery) {
            this.iModel.setObjects(iIndelivery.getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSIndeliveryListPrinter.SSInventoryRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

