/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSStock;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.graphics.SSImage;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSInventoryBasisPrinter
extends SSPrinter {
    private List<SSProduct> iProducts = SSProductMath.getStockProducts(SSDB.getInstance().getProducts());
    private SSStock iStock = new SSStock();

    public SSInventoryBasisPrinter() {
        this.iStock.update();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("inventorybasis.jrxml");
        this.setDetail("inventorybasis.jrxml");
    }

    public SSInventoryBasisPrinter(Date iDate) {
        this.iStock.update(iDate);
        this.addParameter("periodTitle", SSBundle.getBundle().getString("inventorybasisreport.periodtitle"));
        this.addParameter("periodText", iDate);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("inventorybasis.jrxml");
        this.setDetail("inventorybasis.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("inventorybasisreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("image.check", SSImage.getImage("CHECK"));
        SSDefaultTableModel<SSProduct> iModel = new SSDefaultTableModel<SSProduct>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSProduct iProduct = (SSProduct)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iProduct.getNumber();
                        break;
                    }
                    case 1: {
                        value = iProduct.getDescription();
                        break;
                    }
                    case 2: {
                        value = iProduct.isExpired();
                        break;
                    }
                    case 3: {
                        value = iProduct.getUnit() == null ? null : iProduct.getUnit().getName();
                        break;
                    }
                    case 4: {
                        value = SSInventoryBasisPrinter.this.iStock.getQuantity(iProduct);
                        break;
                    }
                    case 5: {
                        value = iProduct.getWarehouseLocation() == null ? "" : iProduct.getWarehouseLocation();
                    }
                }
                return value;
            }
        };
        iModel.addColumn("product.number");
        iModel.addColumn("product.description");
        iModel.addColumn("product.expired");
        iModel.addColumn("product.unit");
        iModel.addColumn("product.stockquantity");
        iModel.addColumn("product.warehouselocation");
        Collections.sort(this.iProducts, new Comparator<SSProduct>(){

            @Override
            public int compare(SSProduct iProduct1, SSProduct iProduct2) {
                if (iProduct1.getWarehouseLocation() == null && iProduct2.getWarehouseLocation() == null) {
                    return 0;
                }
                if (iProduct1.getWarehouseLocation() != null && iProduct2.getWarehouseLocation() == null) {
                    return 1;
                }
                if (iProduct1.getWarehouseLocation() == null && iProduct2.getWarehouseLocation() != null) {
                    return -1;
                }
                return iProduct1.getWarehouseLocation().compareTo(iProduct2.getWarehouseLocation());
            }
        });
        iModel.setObjects(this.iProducts);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSInventoryBasisPrinter");
        sb.append("{iProducts=").append(this.iProducts);
        sb.append(", iStock=").append(this.iStock);
        sb.append('}');
        return sb.toString();
    }
}

