/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSInventory;
import se.swedsoft.bookkeeping.data.SSInventoryRow;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSInventoryListPrinter
extends SSPrinter {
    private SSInventoryRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSInventory> iInventories;

    public SSInventoryListPrinter() {
        this(SSDB.getInstance().getInventories());
    }

    public SSInventoryListPrinter(List<SSInventory> iInventories) {
        this.iInventories = iInventories;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("inventorylist.jrxml");
        this.setDetail("inventorylist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("inventorylistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSInventoryRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSInventory> iModel = new SSDefaultTableModel<SSInventory>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInventory.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSInventory iInventory = (SSInventory)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iInventory.getNumber();
                        break;
                    }
                    case 1: {
                        value = this.iFormat.format(iInventory.getDate());
                        break;
                    }
                    case 2: {
                        value = iInventory.getText();
                        break;
                    }
                    case 3: {
                        SSInventoryListPrinter.this.iPrinter.setInventory(iInventory);
                        SSInventoryListPrinter.this.iDataSource.reset();
                        value = SSInventoryListPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("inventory.number");
        iModel.addColumn("inventory.date");
        iModel.addColumn("inventory.text");
        iModel.addColumn("inventory.rows");
        Collections.sort(this.iInventories, new Comparator<SSInventory>(){

            @Override
            public int compare(SSInventory o1, SSInventory o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iInventories);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSInventoryListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iInventories=").append(this.iInventories);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSInventoryRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSInventoryRow> iModel;

        public SSInventoryRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("inventorylist.row.jrxml");
            this.setSummary("inventorylist.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSInventoryRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSInventoryRow iRow = (SSInventoryRow)this.getObject(rowIndex);
                    SSProduct iProduct = iRow.getProduct();
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iProduct == null ? null : iProduct.getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getStockQuantity();
                            break;
                        }
                        case 3: {
                            value = iRow.getInventoryQuantity();
                            break;
                        }
                        case 4: {
                            value = iRow.getChange();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("inventoryrow.product");
            this.iModel.addColumn("inventoryrow.descripion");
            this.iModel.addColumn("inventoryrow.stockquantity");
            this.iModel.addColumn("inventoryrow.inventoryquantity");
            this.iModel.addColumn("inventoryrow.change");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setInventory(SSInventory iInventory) {
            this.iModel.setObjects(iInventory.getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSInventoryListPrinter.SSInventoryRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

