/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSOrderMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSOrderListPrinter
extends SSPrinter {
    private SSOrderRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSOrder> iOrders;

    public SSOrderListPrinter() {
        this(SSDB.getInstance().getOrders());
    }

    public SSOrderListPrinter(List<SSOrder> iOrders) {
        this.iOrders = iOrders;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("orderlist.jrxml");
        this.setDetail("orderlist.jrxml");
        this.setSummary("orderlist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("orderlistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSOrderRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSOrder> iModel = new SSDefaultTableModel<SSOrder>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSOrder iOrder = (SSOrder)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iOrder.getNumber();
                        break;
                    }
                    case 1: {
                        value = iOrder.getCustomerNr();
                        break;
                    }
                    case 2: {
                        value = iOrder.getCustomerName();
                        break;
                    }
                    case 3: {
                        value = this.iFormat.format(iOrder.getDate());
                        break;
                    }
                    case 4: {
                        value = iOrder.getCurrency() == null ? null : iOrder.getCurrency().getName();
                        break;
                    }
                    case 5: {
                        SSOrderListPrinter.this.iPrinter.setOrder(iOrder);
                        SSOrderListPrinter.this.iDataSource.reset();
                        value = SSOrderListPrinter.this.iDataSource;
                        break;
                    }
                    case 6: {
                        BigDecimal iSum = new BigDecimal(0);
                        iSum = iSum.add(SSOrderMath.getNetSum(iOrder).multiply(iOrder.getCurrencyRate()));
                        value = iSum;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("order.number");
        iModel.addColumn("order.customernr");
        iModel.addColumn("order.customername");
        iModel.addColumn("order.date");
        iModel.addColumn("order.currency");
        iModel.addColumn("order.rows");
        iModel.addColumn("order.sum");
        Collections.sort(this.iOrders, new Comparator<SSOrder>(){

            @Override
            public int compare(SSOrder o1, SSOrder o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iOrders);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSOrderListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iOrders=").append(this.iOrders);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSOrderRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSSaleRow> iModel;

        public SSOrderRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("orderlist.row.jrxml");
            this.setSummary("orderlist.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSSaleRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSaleRow iRow = (SSSaleRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getQuantity();
                            break;
                        }
                        case 3: {
                            value = iRow.getUnit() == null ? null : iRow.getUnit().getName();
                            break;
                        }
                        case 4: {
                            value = iRow.getUnitprice();
                            break;
                        }
                        case 5: {
                            value = iRow.getDiscount();
                            break;
                        }
                        case 6: {
                            value = iRow.getSum();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("row.number");
            this.iModel.addColumn("row.description");
            this.iModel.addColumn("row.count");
            this.iModel.addColumn("row.unit");
            this.iModel.addColumn("row.unitprice");
            this.iModel.addColumn("row.discount");
            this.iModel.addColumn("row.sum");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setOrder(SSOrder iOrder) {
            this.iModel.setObjects(iOrder.getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSOrderListPrinter.SSOrderRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

