/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.SSOwnReportCalculator;
import se.swedsoft.bookkeeping.calc.data.SSOwnReportAccountGroup;
import se.swedsoft.bookkeeping.calc.data.SSOwnReportAccountSchema;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSOwnReport;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSOwnReportPrinter
extends SSPrinter {
    private static ResourceBundle bundle = SSBundle.getBundle();
    SSOwnReport iOwnReport;
    SSNewProject iProject;
    SSNewResultUnit iResultUnit;
    SSOwnReportAccountSchema iAccountSchema;
    Date iDateFrom;
    Date iDateTo;
    Map<Integer, String> iSummaries;
    protected Map<SSAccount, BigDecimal> iColumn1;
    protected Map<SSAccount, BigDecimal> iColumn2;
    protected Map<SSAccount, BigDecimal> iColumn3;

    public SSOwnReportPrinter(Date pFrom, Date pTo, SSOwnReport pOwnReport) {
        this.iDateFrom = pFrom;
        this.iDateTo = pTo;
        this.iOwnReport = pOwnReport;
        this.iProject = this.iOwnReport.getProjectNr() == null ? null : SSDB.getInstance().getProject(this.iOwnReport.getProjectNr());
        this.iResultUnit = this.iOwnReport.getResultUnitNr() == null ? null : SSDB.getInstance().getResultUnit(this.iOwnReport.getResultUnitNr());
        this.iAccountSchema = SSOwnReportAccountSchema.getSchema(this.iOwnReport);
        this.iSummaries = new HashMap<Integer, String>();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("resultcolumns.jrxml");
        this.setDetail("resultown.jrxml");
        this.setSummary("resultown.jrxml");
    }

    @Override
    public String getTitle() {
        return this.iOwnReport.getName();
    }

    private int getSummaryGroup(ResultRow iRow, ResultRow iLastVisibleRow) {
        int iSummaryGroup = -1;
        for (Integer iSummary : this.iSummaries.keySet()) {
            if (iRow.getLevelGroup(1) != iSummary.intValue()) continue;
            iSummaryGroup = iSummary;
            break;
        }
        return iSummaryGroup;
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        if (this.iProject != null) {
            this.addParameter("periodTitle", SSBundle.getBundle().getString("resultreport.projectperiod"));
            this.addParameter("periodText", this.iProject.getName());
        }
        if (this.iResultUnit != null) {
            this.addParameter("periodTitle", SSBundle.getBundle().getString("resultreport.resultunitperiod"));
            this.addParameter("periodText", this.iResultUnit.getName());
        }
        SSOwnReportCalculator iCalculator = this.getCalculator();
        iCalculator.calculate();
        this.getColumns(iCalculator);
        List<SSOwnReportAccountGroup> iResultGroups = this.iAccountSchema.getResultGroups();
        this.getSummaries(iResultGroups);
        List<SSAccount> iAccounts = SSDB.getInstance().getCurrentYear().getAccounts();
        LinkedList<ResultRow> iRows = new LinkedList<ResultRow>();
        ResultRow iLastVisibleRow = null;
        for (SSOwnReportAccountGroup iResultGroup : iResultGroups) {
            List<ResultRow> iCurrentRows = this.getRows(iResultGroup, iAccounts, 0);
            for (ResultRow iRow : iCurrentRows) {
                boolean isColumn3;
                SSAccount iAccount = iRow.iAccount;
                boolean isColumn1 = this.iColumn1 != null && this.iColumn1.containsKey(iAccount);
                boolean isColumn2 = this.iColumn2 != null && this.iColumn2.containsKey(iAccount);
                boolean bl = isColumn3 = this.iColumn3 != null && this.iColumn3.containsKey(iAccount);
                if (!isColumn1 && !isColumn2 && !isColumn3) continue;
                iRows.add(iRow);
                iRow.iSummaryGroup = this.getSummaryGroup(iRow, iLastVisibleRow);
                iLastVisibleRow = iRow;
            }
        }
        SSDefaultTableModel<ResultRow> iModel = new SSDefaultTableModel<ResultRow>(){

            @Override
            public Class getType() {
                return ResultRow.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                ResultRow iRow = (ResultRow)this.getObject(rowIndex);
                SSAccount iAccount = iRow.iAccount;
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iAccount.getNumber();
                        break;
                    }
                    case 1: {
                        value = iAccount.getDescription();
                        break;
                    }
                    case 2: {
                        value = iRow.getLevelGroup(0);
                        break;
                    }
                    case 3: {
                        value = iRow.getLevelGroup(1);
                        break;
                    }
                    case 4: {
                        value = SSOwnReportPrinter.this.iColumn1 == null ? null : SSOwnReportPrinter.this.iColumn1.get(iAccount);
                        break;
                    }
                    case 5: {
                        value = SSOwnReportPrinter.this.iColumn2 == null ? null : SSOwnReportPrinter.this.iColumn2.get(iAccount);
                        break;
                    }
                    case 6: {
                        value = SSOwnReportPrinter.this.iColumn3 == null ? null : SSOwnReportPrinter.this.iColumn3.get(iAccount);
                        break;
                    }
                    case 7: {
                        value = iRow.iLevelGroups[0] != null ? iRow.iLevelGroups[0].getName() : "";
                        break;
                    }
                    case 8: {
                        value = iRow.iLevelGroups[1] != null ? iRow.iLevelGroups[1].getName() : "";
                        break;
                    }
                    case 9: {
                        value = iRow.iLevelGroups[0] != null ? iRow.iLevelGroups[0].getSumTitle() : "";
                        break;
                    }
                    case 10: {
                        value = iRow.iLevelGroups[1] != null ? iRow.iLevelGroups[1].getSumTitle() : "";
                        break;
                    }
                    case 11: {
                        value = iRow.iSummaryGroup;
                        break;
                    }
                    case 12: {
                        value = SSOwnReportPrinter.this.iSummaries.get(iRow.iSummaryGroup);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("account.number");
        iModel.addColumn("account.description");
        iModel.addColumn("account.group.1");
        iModel.addColumn("account.group.2");
        iModel.addColumn("account.value.1");
        iModel.addColumn("account.value.2");
        iModel.addColumn("account.value.3");
        iModel.addColumn("group.1.title");
        iModel.addColumn("group.2.title");
        iModel.addColumn("group.1.sumtitle");
        iModel.addColumn("group.2.sumtitle");
        iModel.addColumn("summary.index");
        iModel.addColumn("summary.title");
        iModel.setObjects((List<ResultRow>)iRows);
        return iModel;
    }

    protected SSOwnReportCalculator getCalculator() {
        return new SSOwnReportCalculator(this.iDateFrom, this.iDateTo, this.iOwnReport, this.iProject, this.iResultUnit);
    }

    protected void getColumns(SSOwnReportCalculator iCalculator) {
        this.addParameter("column.text.1", bundle.getString("resultreport.column.4"));
        this.addParameter("column.text.2", bundle.getString("resultreport.column.1"));
        this.addParameter("column.text.3", bundle.getString("resultreport.column.5"));
        this.iColumn1 = iCalculator.getChangeBudget();
        this.iColumn2 = iCalculator.getChangePeriod();
        this.iColumn3 = iCalculator.getDeviation(this.iColumn1, this.iColumn2);
    }

    private List<ResultRow> getRows(SSOwnReportAccountGroup iGroup, List<SSAccount> iAccounts, int iLevel) {
        LinkedList<ResultRow> iRows;
        block4: {
            block3: {
                List<SSAccount> iGroupAccounts = iGroup.getAccounts();
                iRows = new LinkedList<ResultRow>();
                if (iGroup.getGroups() != null || iGroup.getAccounts() == null) break block3;
                for (SSAccount iAccount : iGroupAccounts) {
                    ResultRow iRow = new ResultRow();
                    iRow.iAccount = iAccount;
                    iRow.iLevelGroups[iLevel] = iGroup;
                    iRows.add(iRow);
                }
                break block4;
            }
            if (iGroup.getGroups() == null) break block4;
            for (SSOwnReportAccountGroup iBalanceGroup : iGroup.getGroups()) {
                iRows.addAll(this.getRows(iBalanceGroup, iAccounts, iLevel + 1));
            }
            for (ResultRow iRow : iRows) {
                iRow.iLevelGroups[iLevel] = iGroup;
            }
        }
        return iRows;
    }

    private void getSummaries(List<SSOwnReportAccountGroup> iGroups) {
        for (SSOwnReportAccountGroup iGroup : iGroups) {
            if (iGroup.getGroups() == null) continue;
            for (SSOwnReportAccountGroup iBalanceGroup : iGroup.getGroups()) {
                if (iBalanceGroup.getAccounts() != null) continue;
                this.iSummaries.put(iBalanceGroup.getId(), iBalanceGroup.getName());
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSOwnReportPrinter");
        sb.append("{iAccountSchema=").append(this.iAccountSchema);
        sb.append(", iColumn1=").append(this.iColumn1);
        sb.append(", iColumn2=").append(this.iColumn2);
        sb.append(", iColumn3=").append(this.iColumn3);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iOwnReport=").append(this.iOwnReport);
        sb.append(", iProject=").append(this.iProject);
        sb.append(", iResultUnit=").append(this.iResultUnit);
        sb.append(", iSummaries=").append(this.iSummaries);
        sb.append('}');
        return sb.toString();
    }

    private class ResultRow {
        SSAccount iAccount;
        SSOwnReportAccountGroup[] iLevelGroups = new SSOwnReportAccountGroup[2];
        Integer iSummaryGroup;

        private ResultRow() {
        }

        public int getLevelGroup(int iLevel) {
            if (this.iLevelGroups[iLevel] == null) {
                return -1;
            }
            return this.iLevelGroups[iLevel].getId();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSOwnReportPrinter.ResultRow");
            sb.append("{iAccount=").append(this.iAccount);
            sb.append(", iLevelGroups=").append(this.iLevelGroups == null ? "null" : Arrays.asList(this.iLevelGroups).toString());
            sb.append(", iSummaryGroup=").append(this.iSummaryGroup);
            sb.append('}');
            return sb.toString();
        }
    }
}

