/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSStock;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSProductListPrinter
extends SSPrinter {
    private SSParcelPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSProduct> iProducts;
    private SSStock iStock;

    public SSProductListPrinter() {
        this(SSDB.getInstance().getProducts());
    }

    public SSProductListPrinter(List<SSProduct> iProducts) {
        this.iProducts = iProducts;
        this.iStock = new SSStock(true);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("productlist.jrxml");
        this.setDetail("productlist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("productlistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSParcelPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSProduct> iModel = new SSDefaultTableModel<SSProduct>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSProduct iProduct = (SSProduct)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iProduct.isParcel();
                        break;
                    }
                    case 1: {
                        value = iProduct.getNumber();
                        break;
                    }
                    case 2: {
                        value = iProduct.getDescription();
                        break;
                    }
                    case 3: {
                        value = iProduct.getUnit() == null ? null : iProduct.getUnit().getName();
                        break;
                    }
                    case 4: {
                        value = iProduct.getSellingPrice();
                        break;
                    }
                    case 5: {
                        value = iProduct.getWarehouseLocation() == null ? "" : iProduct.getWarehouseLocation();
                        break;
                    }
                    case 6: {
                        value = SSProductListPrinter.this.iStock.getQuantity(iProduct);
                        break;
                    }
                    case 7: {
                        SSProductListPrinter.this.iPrinter.setProduct(iProduct);
                        SSProductListPrinter.this.iDataSource.reset();
                        value = SSProductListPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("product.isparcel");
        iModel.addColumn("product.number");
        iModel.addColumn("product.description");
        iModel.addColumn("product.unit");
        iModel.addColumn("product.unitprice");
        iModel.addColumn("product.warehouselocation");
        iModel.addColumn("product.warehousequantity");
        iModel.addColumn("product.rows");
        Collections.sort(this.iProducts, new Comparator<SSProduct>(){

            @Override
            public int compare(SSProduct o1, SSProduct o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        iModel.setObjects(this.iProducts);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSProductListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iProducts=").append(this.iProducts);
        sb.append(", iStock=").append(this.iStock);
        sb.append('}');
        return sb.toString();
    }

    private class SSParcelPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSProductRow> iModel;

        public SSParcelPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("productlist.parcel.jrxml");
            this.iModel = new SSDefaultTableModel<SSProductRow>(){

                @Override
                public Class getType() {
                    return SSProductRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSProductRow iProductRow = (SSProductRow)this.getObject(rowIndex);
                    SSProduct iProduct = iProductRow.getProduct(SSDB.getInstance().getProducts());
                    switch (columnIndex) {
                        case 0: {
                            value = iProductRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iProductRow.getDescription();
                            break;
                        }
                        case 2: {
                            value = iProductRow.getQuantity();
                            break;
                        }
                        case 3: {
                            value = iProduct == null || iProduct.getUnit() == null ? null : iProduct.getUnit().getName();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("product.number");
            this.iModel.addColumn("product.description");
            this.iModel.addColumn("product.count");
            this.iModel.addColumn("product.unit");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setProduct(SSProduct iProduct) {
            this.iModel.setObjects(iProduct.getParcelRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSProductListPrinter.SSParcelPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

