/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.text.DateFormat;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSProjectsPrinter
extends SSPrinter {
    List<SSNewProject> iProjects;

    public SSProjectsPrinter() {
        this(SSDB.getInstance().getProjects());
    }

    public SSProjectsPrinter(List<SSNewProject> pProjects) {
        this.iProjects = pProjects;
        this.setPageHeader("header.jrxml");
        this.setColumnHeader("projects.jrxml");
        this.setDetail("projects.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("projectreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        final DateFormat iFormat = DateFormat.getDateInstance(3);
        SSDefaultTableModel<SSNewProject> iModel = new SSDefaultTableModel<SSNewProject>(){

            @Override
            public Class getType() {
                return SSNewProject.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSNewProject iProject = (SSNewProject)this.getObject(rowIndex);
                String value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iProject.getNumber();
                        break;
                    }
                    case 1: {
                        value = iProject.getName();
                        break;
                    }
                    case 2: {
                        value = iProject.getDescription();
                        break;
                    }
                    case 3: {
                        value = iProject.getConcluded() ? iFormat.format(iProject.getConcludedDate()) : null;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("project.number");
        iModel.addColumn("project.name");
        iModel.addColumn("project.description");
        iModel.addColumn("project.concluded");
        iModel.setObjects(this.iProjects);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSProjectsPrinter");
        sb.append("{iProjects=").append(this.iProjects);
        sb.append('}');
        return sb.toString();
    }
}

