/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.SSResultCalculator;
import se.swedsoft.bookkeeping.calc.data.SSAccountGroup;
import se.swedsoft.bookkeeping.calc.data.SSAccountSchema;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSResultPrinter
extends SSPrinter {
    private static ResourceBundle bundle = SSBundle.getBundle();
    SSNewAccountingYear iYearData;
    SSAccountSchema iAccountSchema;
    Date iDateFrom;
    Date iDateTo;
    boolean iShowBudget;
    boolean iShowPrevYear;
    private int iLastVisibleSummaryGroup;
    protected Map<SSAccount, BigDecimal> iColumn1;
    protected Map<SSAccount, BigDecimal> iColumn2;
    protected Map<SSAccount, BigDecimal> iColumn3;

    public SSResultPrinter(Date pFrom, Date pTo, boolean pShowBudget, boolean pShowPrevYear) {
        this(SSDB.getInstance().getCurrentYear(), pFrom, pTo, pShowBudget, pShowPrevYear);
    }

    public SSResultPrinter(SSNewAccountingYear pYearData, Date pFrom, Date pTo, boolean pShowBudget, boolean pShowPrevYear) {
        this.iYearData = pYearData;
        this.iDateFrom = pFrom;
        this.iDateTo = pTo;
        this.iShowBudget = pShowBudget;
        this.iShowPrevYear = pShowPrevYear;
        this.iAccountSchema = SSAccountSchema.getAccountSchema(pYearData);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("resultcolumns.jrxml");
        this.setDetail("result.jrxml");
        this.setSummary("result.jrxml");
    }

    @Override
    public String getTitle() {
        return bundle.getString("resultreport.title");
    }

    private int getSummaryGroup(ResultRow iRow, ResultRow iLastVisibleRow) {
        int iSummaryGroup = -1;
        if (iRow.getLevelGroup(1) >= 1 && iRow.getLevelGroup(1) <= 5) {
            iSummaryGroup = 1;
        }
        if (iRow.getLevelGroup(1) >= 6 && iRow.getLevelGroup(1) <= 7) {
            iSummaryGroup = 2;
        }
        if (iRow.getLevelGroup(1) >= 8 && iRow.getLevelGroup(1) <= 9) {
            iSummaryGroup = 3;
        }
        if (iRow.getLevelGroup(1) >= 10 && iRow.getLevelGroup(1) <= 10) {
            iSummaryGroup = 4;
        }
        if (iRow.getLevelGroup(1) >= 11 && iRow.getLevelGroup(1) <= 11) {
            iSummaryGroup = 5;
        }
        if (iRow.getLevelGroup(1) >= 12 && iRow.getLevelGroup(1) <= 12) {
            iSummaryGroup = 6;
        }
        if (this.iLastVisibleSummaryGroup != iSummaryGroup) {
            if (iLastVisibleRow != null) {
                iLastVisibleRow.iSummaryGroup = this.iLastVisibleSummaryGroup;
            }
            this.iLastVisibleSummaryGroup = iSummaryGroup;
            return -1;
        }
        return -1;
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        SSResultCalculator iCalculator = this.getCalculator();
        iCalculator.calculate();
        this.getColumns(iCalculator);
        List<SSAccountGroup> iResultGroups = this.iAccountSchema.getResultGroups();
        List<SSAccount> iAccounts = this.iYearData.getAccounts();
        LinkedList<ResultRow> iRows = new LinkedList<ResultRow>();
        this.iLastVisibleSummaryGroup = 1;
        ResultRow iLastVisibleRow = null;
        for (SSAccountGroup iResultGroup : iResultGroups) {
            List<ResultRow> iCurrentRows = this.getRows(iResultGroup, iAccounts, 0);
            for (ResultRow iRow : iCurrentRows) {
                boolean isColumn3;
                SSAccount iAccount = iRow.iAccount;
                boolean isColumn1 = this.iColumn1 != null && this.iColumn1.containsKey(iAccount);
                boolean isColumn2 = this.iColumn2 != null && this.iColumn2.containsKey(iAccount);
                boolean bl = isColumn3 = this.iColumn3 != null && this.iColumn3.containsKey(iAccount);
                if (!isColumn1 && !isColumn2 && !isColumn3) continue;
                iRows.add(iRow);
                iRow.iSummaryGroup = this.getSummaryGroup(iRow, iLastVisibleRow);
                iLastVisibleRow = iRow;
            }
        }
        SSDefaultTableModel<ResultRow> iModel = new SSDefaultTableModel<ResultRow>(){

            @Override
            public Class getType() {
                return ResultRow.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                ResultRow iRow = (ResultRow)this.getObject(rowIndex);
                SSAccount iAccount = iRow.iAccount;
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iAccount.getNumber();
                        break;
                    }
                    case 1: {
                        value = iAccount.getDescription();
                        break;
                    }
                    case 2: {
                        value = iRow.getLevelGroup(0);
                        break;
                    }
                    case 3: {
                        value = iRow.getLevelGroup(1);
                        break;
                    }
                    case 4: {
                        value = SSResultPrinter.this.iColumn1 == null ? null : SSResultPrinter.this.iColumn1.get(iAccount);
                        break;
                    }
                    case 5: {
                        value = SSResultPrinter.this.iColumn2 == null ? null : SSResultPrinter.this.iColumn2.get(iAccount);
                        break;
                    }
                    case 6: {
                        value = SSResultPrinter.this.iColumn3 == null ? null : SSResultPrinter.this.iColumn3.get(iAccount);
                        break;
                    }
                    case 7: {
                        value = iRow.iLevelGroups[0] != null ? iRow.iLevelGroups[0].getTitle() : "";
                        break;
                    }
                    case 8: {
                        value = iRow.iLevelGroups[1] != null ? iRow.iLevelGroups[1].getTitle() : "";
                        break;
                    }
                    case 9: {
                        value = iRow.iLevelGroups[0] != null ? iRow.iLevelGroups[0].getSumTitle() : "";
                        break;
                    }
                    case 10: {
                        value = iRow.iLevelGroups[1] != null ? iRow.iLevelGroups[1].getSumTitle() : "";
                        break;
                    }
                    case 11: {
                        value = iRow.iSummaryGroup;
                        break;
                    }
                    case 12: {
                        value = bundle.getString("resultreport.summary." + iRow.getLevelGroup(1));
                    }
                }
                return value;
            }
        };
        iModel.addColumn("account.number");
        iModel.addColumn("account.description");
        iModel.addColumn("account.group.1");
        iModel.addColumn("account.group.2");
        iModel.addColumn("account.value.1");
        iModel.addColumn("account.value.2");
        iModel.addColumn("account.value.3");
        iModel.addColumn("group.1.title");
        iModel.addColumn("group.2.title");
        iModel.addColumn("group.1.sumtitle");
        iModel.addColumn("group.2.sumtitle");
        iModel.addColumn("summary.index");
        iModel.addColumn("summary.title");
        iModel.setObjects((List<ResultRow>)iRows);
        return iModel;
    }

    protected SSResultCalculator getCalculator() {
        return new SSResultCalculator(this.iYearData, this.iDateFrom, this.iDateTo, null, null);
    }

    protected void getColumns(SSResultCalculator iCalculator) {
        if (this.iShowBudget) {
            this.addParameter("column.text.1", bundle.getString("resultreport.column.4"));
            this.addParameter("column.text.2", bundle.getString("resultreport.column.1"));
            this.addParameter("column.text.3", bundle.getString("resultreport.column.5"));
            this.iColumn1 = iCalculator.getChangeBudget();
            this.iColumn2 = iCalculator.getChangePeriod();
            this.iColumn3 = iCalculator.getDeviation(this.iColumn1, this.iColumn2);
        } else if (this.iShowPrevYear) {
            this.addParameter("column.text.1", bundle.getString("resultreport.column.6"));
            this.addParameter("column.text.2", bundle.getString("resultreport.column.1"));
            this.addParameter("column.text.3", bundle.getString("resultreport.column.5"));
            this.iColumn1 = iCalculator.getChangeLastYear();
            this.iColumn2 = iCalculator.getChangePeriod();
            this.iColumn3 = iCalculator.getDeviation(this.iColumn1, this.iColumn2);
        } else {
            this.addParameter("column.text.2", bundle.getString("resultreport.column.1"));
            this.addParameter("column.text.3", bundle.getString("resultreport.column.2"));
            this.iColumn1 = null;
            this.iColumn2 = iCalculator.getChangePeriod();
            this.iColumn3 = iCalculator.getChange();
        }
    }

    private List<ResultRow> getRows(SSAccountGroup iGroup, List<SSAccount> iAccounts, int iLevel) {
        List<SSAccount> iGroupAccounts = iGroup.getGroupAccounts(iAccounts);
        LinkedList<ResultRow> iRows = new LinkedList<ResultRow>();
        if (iGroup.getGroups() == null) {
            for (SSAccount iAccount : iGroupAccounts) {
                ResultRow iRow = new ResultRow();
                iRow.iAccount = iAccount;
                iRow.iLevelGroups[iLevel] = iGroup;
                iRows.add(iRow);
            }
        } else {
            for (SSAccountGroup iBalanceGroup : iGroup.getGroups()) {
                iRows.addAll(this.getRows(iBalanceGroup, iAccounts, iLevel + 1));
            }
            for (ResultRow iRow : iRows) {
                iRow.iLevelGroups[iLevel] = iGroup;
            }
        }
        return iRows;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSResultPrinter");
        sb.append("{iAccountSchema=").append(this.iAccountSchema);
        sb.append(", iColumn1=").append(this.iColumn1);
        sb.append(", iColumn2=").append(this.iColumn2);
        sb.append(", iColumn3=").append(this.iColumn3);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iLastVisibleSummaryGroup=").append(this.iLastVisibleSummaryGroup);
        sb.append(", iShowBudget=").append(this.iShowBudget);
        sb.append(", iShowPrevYear=").append(this.iShowPrevYear);
        sb.append(", iYearData=").append(this.iYearData);
        sb.append('}');
        return sb.toString();
    }

    private class ResultRow {
        SSAccount iAccount;
        SSAccountGroup[] iLevelGroups = new SSAccountGroup[2];
        Integer iSummaryGroup;

        private ResultRow() {
        }

        public int getLevelGroup(int iLevel) {
            if (this.iLevelGroups[iLevel] == null) {
                return -1;
            }
            return this.iLevelGroups[iLevel].getId();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSResultPrinter.ResultRow");
            sb.append("{iAccount=").append(this.iAccount);
            sb.append(", iLevelGroups=").append(this.iLevelGroups == null ? "null" : Arrays.asList(this.iLevelGroups).toString());
            sb.append(", iSummaryGroup=").append(this.iSummaryGroup);
            sb.append('}');
            return sb.toString();
        }
    }
}

