/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.util.List;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSResultUnitPrinter
extends SSPrinter {
    List<SSNewResultUnit> iResultUnits;

    public SSResultUnitPrinter() {
        this(SSDB.getInstance().getResultUnits());
    }

    public SSResultUnitPrinter(List<SSNewResultUnit> pResultUnits) {
        this.iResultUnits = pResultUnits;
        this.setPageHeader("header.jrxml");
        this.setColumnHeader("resultunits.jrxml");
        this.setDetail("resultunits.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("resultunitreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        SSDefaultTableModel<SSNewResultUnit> iModel = new SSDefaultTableModel<SSNewResultUnit>(){

            @Override
            public Class getType() {
                return SSNewResultUnit.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSNewResultUnit iResultUnit = (SSNewResultUnit)this.getObject(rowIndex);
                String value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iResultUnit.getNumber();
                        break;
                    }
                    case 1: {
                        value = iResultUnit.getName();
                        break;
                    }
                    case 2: {
                        value = iResultUnit.getDescription();
                    }
                }
                return value;
            }
        };
        iModel.addColumn("resultunit.number");
        iModel.addColumn("resultunit.name");
        iModel.addColumn("resultunit.description");
        iModel.setObjects(this.iResultUnits);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSResultUnitPrinter");
        sb.append("{iResultUnits=").append(this.iResultUnits);
        sb.append('}');
        return sb.toString();
    }
}

