/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.util.Date;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.SSResultCalculator;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.print.report.SSResultPrinter;

public class SSResultUnitResultPrinter
extends SSResultPrinter {
    private static ResourceBundle bundle = SSBundle.getBundle();
    SSNewResultUnit iResultUnit;

    public SSResultUnitResultPrinter(Date pFrom, Date pTo, SSNewResultUnit pResultUnit) {
        super(pFrom, pTo, false, false);
        this.iResultUnit = pResultUnit;
        this.addParameter("periodTitle", SSBundle.getBundle().getString("resultreport.resultunitperiod"));
        this.addParameter("periodText", this.iResultUnit != null ? this.iResultUnit.getName() : SSBundle.getBundle().getString("resultreport.resultunitperiod.all"));
    }

    public SSResultUnitResultPrinter(SSNewAccountingYear pYearData, Date pFrom, Date pTo, SSNewResultUnit pResultUnit) {
        super(pYearData, pFrom, pTo, false, false);
        this.iResultUnit = pResultUnit;
        this.addParameter("periodTitle", SSBundle.getBundle().getString("resultreport.resultunitperiod"));
        this.addParameter("periodText", this.iResultUnit != null ? this.iResultUnit.getName() : SSBundle.getBundle().getString("resultreport.resultunitperiod.all"));
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("resultreport.resultunit.title");
    }

    @Override
    protected SSResultCalculator getCalculator() {
        return new SSResultCalculator(this.iYearData, this.iDateFrom, this.iDateTo, null, this.iResultUnit);
    }

    @Override
    protected void getColumns(SSResultCalculator iCalculator) {
        this.addParameter("column.text.2", bundle.getString("resultreport.column.1"));
        this.addParameter("column.text.3", bundle.getString("resultreport.column.7"));
        this.iColumn1 = null;
        this.iColumn2 = iCalculator.getResultunitChangePeriod();
        this.iColumn3 = iCalculator.getResultunitChange();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSResultUnitResultPrinter");
        sb.append("{iResultUnit=").append(this.iResultUnit);
        sb.append('}');
        return sb.toString();
    }
}

