/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSCreditInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSResultUnitRevenuePrinter
extends SSPrinter {
    private SSMonthlyDistributionPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSNewResultUnit> iResultUnits;
    private Date iDateFrom;
    private Date iDateTo;
    private Map<String, Map<SSMonth, BigDecimal>> iResultUnitRevenue;

    public SSResultUnitRevenuePrinter(List<SSNewResultUnit> pResultUnits, Date pFrom, Date pTo) {
        this.iResultUnits = pResultUnits;
        this.iDateFrom = SSDateMath.floor(pFrom);
        this.iDateTo = SSDateMath.ceil(pTo);
        this.calculate();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("resultunitrevenue.jrxml");
        this.setDetail("resultunitrevenue.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("resultunitrevenue.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        this.iPrinter = new SSMonthlyDistributionPrinter(this.iDateFrom, this.iDateTo);
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSNewResultUnit> iModel = new SSDefaultTableModel<SSNewResultUnit>(){

            @Override
            public Class getType() {
                return SSNewResultUnit.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSNewResultUnit iResultUnit = (SSNewResultUnit)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iResultUnit.getNumber();
                        break;
                    }
                    case 1: {
                        value = iResultUnit.getName();
                        break;
                    }
                    case 2: {
                        SSResultUnitRevenuePrinter.this.iPrinter.setResultUnit(iResultUnit, (Map)SSResultUnitRevenuePrinter.this.iResultUnitRevenue.get(iResultUnit.getNumber()));
                        SSResultUnitRevenuePrinter.this.iDataSource.reset();
                        value = SSResultUnitRevenuePrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("resultunit.number");
        iModel.addColumn("resultunit.description");
        iModel.addColumn("month.data");
        iModel.setObjects(this.iResultUnits);
        return iModel;
    }

    private void calculate() {
        this.iResultUnitRevenue = new HashMap<String, Map<SSMonth, BigDecimal>>();
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInvoice iInvoice : iInvoices) {
            if (!iInvoice.getDate().after(this.iDateFrom) || !iInvoice.getDate().before(this.iDateTo)) continue;
            Calendar iCal = Calendar.getInstance();
            iCal.setTime(iInvoice.getDate());
            iCal.set(5, 1);
            Date iFrom = iCal.getTime();
            iCal.set(5, iCal.getActualMaximum(5));
            Date iTo = iCal.getTime();
            SSMonth iMonth = new SSMonth(iFrom, iTo);
            for (SSSaleRow iRow : iInvoice.getRows()) {
                Map<Object, Object> iRevenueInMonth;
                if (iRow.getResultUnitNr() == null || iRow.getSum() == null) continue;
                BigDecimal iSum = SSInvoiceMath.convertToLocal(iInvoice, iRow.getSum());
                if (this.iResultUnitRevenue.containsKey(iRow.getResultUnitNr())) {
                    iRevenueInMonth = this.iResultUnitRevenue.get(iRow.getResultUnitNr());
                    if (iRevenueInMonth.containsKey(iMonth)) {
                        iRevenueInMonth.put(iMonth, ((BigDecimal)iRevenueInMonth.get(iMonth)).add(iSum));
                    } else {
                        iRevenueInMonth.put(iMonth, iSum);
                    }
                } else {
                    iRevenueInMonth = new HashMap<SSMonth, BigDecimal>();
                    iRevenueInMonth.put(iMonth, iSum);
                }
                this.iResultUnitRevenue.put(iRow.getResultUnitNr(), iRevenueInMonth);
            }
        }
        List<SSCreditInvoice> iCreditInvoices = SSDB.getInstance().getCreditInvoices();
        for (SSCreditInvoice iCreditInvoice : iCreditInvoices) {
            if (!iCreditInvoice.getDate().after(this.iDateFrom) || !iCreditInvoice.getDate().before(this.iDateTo)) continue;
            Calendar iCal = Calendar.getInstance();
            iCal.setTime(iCreditInvoice.getDate());
            iCal.set(5, 1);
            Date iFrom = iCal.getTime();
            iCal.set(5, iCal.getActualMaximum(5));
            Date iTo = iCal.getTime();
            SSMonth iMonth = new SSMonth(iFrom, iTo);
            for (SSSaleRow iRow : iCreditInvoice.getRows()) {
                Map<Object, Object> iRevenueInMonth;
                if (iRow.getResultUnitNr() == null || iRow.getSum() == null) continue;
                BigDecimal iSum = SSCreditInvoiceMath.convertToLocal(iCreditInvoice, iRow.getSum());
                if (this.iResultUnitRevenue.containsKey(iRow.getResultUnitNr())) {
                    iRevenueInMonth = this.iResultUnitRevenue.get(iRow.getResultUnitNr());
                    if (iRevenueInMonth.containsKey(iMonth)) {
                        iRevenueInMonth.put(iMonth, ((BigDecimal)iRevenueInMonth.get(iMonth)).subtract(iSum));
                    } else {
                        iRevenueInMonth.put(iMonth, iSum.negate());
                    }
                } else {
                    iRevenueInMonth = new HashMap<SSMonth, BigDecimal>();
                    iRevenueInMonth.put(iMonth, iSum.negate());
                }
                this.iResultUnitRevenue.put(iRow.getResultUnitNr(), iRevenueInMonth);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSResultUnitRevenuePrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iResultUnitRevenue=").append(this.iResultUnitRevenue);
        sb.append(", iResultUnits=").append(this.iResultUnits);
        sb.append('}');
        return sb.toString();
    }

    private class SSMonthlyDistributionPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSMonth> iModel;
        private SSNewResultUnit iResultUnit;
        private Date iFrom;
        private Date iTo;
        private Map<SSMonth, BigDecimal> iRevenue;

        public SSMonthlyDistributionPrinter(Date pFrom, Date pTo) {
            this.iFrom = pFrom;
            this.iTo = pTo;
            this.setMargins(0, 0, 0, 0);
            this.setDetail("resultunitrevenue.monthly.jrxml");
            this.setSummary("resultunitrevenue.monthly.jrxml");
            this.iModel = new SSDefaultTableModel<SSMonth>(SSMonth.splitYearIntoMonths(this.iFrom, this.iTo)){

                @Override
                public Class getType() {
                    return SSMonth.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSMonth iMonth = (SSMonth)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iMonth.toString();
                            break;
                        }
                        case 1: {
                            value = iMonth.getName();
                            break;
                        }
                        case 2: {
                            if (SSMonthlyDistributionPrinter.this.iResultUnit != null && SSMonthlyDistributionPrinter.this.iRevenue.containsKey(iMonth)) {
                                value = SSMonthlyDistributionPrinter.this.iRevenue.get(iMonth);
                                break;
                            }
                            value = new BigDecimal(0);
                            break;
                        }
                        case 3: {
                            value = iMonth.isBetween(SSMonthlyDistributionPrinter.this.iFrom, SSMonthlyDistributionPrinter.this.iTo);
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("month.date");
            this.iModel.addColumn("month.description");
            this.iModel.addColumn("month.value");
            this.iModel.addColumn("month.visible");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setResultUnit(SSNewResultUnit pResultUnit, Map<SSMonth, BigDecimal> iMap) {
            this.iResultUnit = pResultUnit;
            this.iRevenue = iMap;
            if (this.iRevenue == null) {
                this.iRevenue = new HashMap<SSMonth, BigDecimal>();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSResultUnitRevenuePrinter.SSMonthlyDistributionPrinter");
            sb.append("{iFrom=").append(this.iFrom);
            sb.append(", iModel=").append(this.iModel);
            sb.append(", iResultUnit=").append(this.iResultUnit);
            sb.append(", iRevenue=").append(this.iRevenue);
            sb.append(", iTo=").append(this.iTo);
            sb.append('}');
            return sb.toString();
        }
    }
}

