/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSSaleReportPrinter
extends SSPrinter {
    private Date iFrom;
    private Date iTo;
    private SortingMode iSortingMode;
    private boolean iAscending;
    private List<SSProduct> iProducts;
    private Integer iDays;
    private Map<String, Integer> iCount;
    private Map<String, BigDecimal> iContribution;
    private Map<String, BigDecimal> iContributionRate;
    private Map<String, BigDecimal> iAverageSellingPrice;
    private Map<String, BigDecimal> iInprices;

    public SSSaleReportPrinter(Date iFrom, Date iTo, SortingMode iSortingMode, boolean iAscending) {
        this.iFrom = iFrom;
        this.iTo = iTo;
        this.iSortingMode = iSortingMode;
        this.iAscending = iAscending;
        this.iProducts = SSDB.getInstance().getProducts();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("salereport.jrxml");
        this.setDetail("salereport.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("salereport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iFrom);
        this.addParameter("dateTo", this.iTo);
        this.calculate();
        SSDefaultTableModel<SSProduct> iModel = new SSDefaultTableModel<SSProduct>(){

            @Override
            public Class getType() {
                return SSProduct.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSProduct iProduct = (SSProduct)this.getObject(rowIndex);
                Integer iProductCount = (Integer)SSSaleReportPrinter.this.iCount.get(iProduct.getNumber());
                BigDecimal iProductContribution = (BigDecimal)SSSaleReportPrinter.this.iContribution.get(iProduct.getNumber());
                BigDecimal iProductContributionRate = (BigDecimal)SSSaleReportPrinter.this.iContributionRate.get(iProduct.getNumber());
                switch (columnIndex) {
                    case 0: {
                        value = iProduct.getNumber();
                        break;
                    }
                    case 1: {
                        value = iProduct.getDescription();
                        break;
                    }
                    case 2: {
                        value = iProductCount;
                        break;
                    }
                    case 3: {
                        if (SSSaleReportPrinter.this.iDays == null || SSSaleReportPrinter.this.iDays == 0) {
                            return null;
                        }
                        value = new BigDecimal((double)iProductCount.intValue() * 30.436875 / (double)SSSaleReportPrinter.this.iDays.intValue());
                        break;
                    }
                    case 4: {
                        if (SSSaleReportPrinter.this.iDays == null || SSSaleReportPrinter.this.iDays == 0) {
                            return null;
                        }
                        value = new BigDecimal((double)iProductCount.intValue() * 7.0 / (double)SSSaleReportPrinter.this.iDays.intValue());
                        break;
                    }
                    case 5: {
                        value = iProduct.getSellingPrice();
                        break;
                    }
                    case 6: {
                        value = SSSaleReportPrinter.this.iInprices.get(iProduct.getNumber());
                        break;
                    }
                    case 7: {
                        value = iProductContribution;
                        break;
                    }
                    case 8: {
                        value = iProductContributionRate;
                        break;
                    }
                    case 9: {
                        if (iProductContribution == null || iProductCount == null) {
                            return null;
                        }
                        value = iProductContribution.multiply(new BigDecimal(iProductCount));
                        break;
                    }
                    case 10: {
                        value = SSSaleReportPrinter.this.iAverageSellingPrice.get(iProduct.getNumber());
                    }
                }
                return value;
            }
        };
        iModel.addColumn("product.number");
        iModel.addColumn("product.description");
        iModel.addColumn("product.count");
        iModel.addColumn("product.monthly");
        iModel.addColumn("product.weekly");
        iModel.addColumn("product.unitprice");
        iModel.addColumn("product.inprice");
        iModel.addColumn("product.contribution");
        iModel.addColumn("product.contributionrate");
        iModel.addColumn("product.grossprofit");
        iModel.addColumn("product.averagesellingprice");
        if (this.iSortingMode == SortingMode.Product) {
            Collections.sort(this.iProducts, new Comparator<SSProduct>(){

                @Override
                public int compare(SSProduct iProduct1, SSProduct iProduct2) {
                    String iNumber1 = iProduct1.getNumber();
                    String iNumber2 = iProduct2.getNumber();
                    if (iNumber1 == null || iNumber2 == null) {
                        return 0;
                    }
                    if (SSSaleReportPrinter.this.iAscending) {
                        return iNumber1.compareTo(iNumber2);
                    }
                    return iNumber2.compareTo(iNumber1);
                }
            });
        }
        if (this.iSortingMode == SortingMode.Period) {
            Collections.sort(this.iProducts, new Comparator<SSProduct>(){

                @Override
                public int compare(SSProduct iProduct1, SSProduct iProduct2) {
                    Integer iCount1 = (Integer)SSSaleReportPrinter.this.iCount.get(iProduct1.getNumber());
                    Integer iCount2 = (Integer)SSSaleReportPrinter.this.iCount.get(iProduct2.getNumber());
                    if (iCount1 == null) {
                        iCount1 = 0;
                    }
                    if (iCount2 == null) {
                        iCount2 = 0;
                    }
                    if (SSSaleReportPrinter.this.iAscending) {
                        return iCount1 - iCount2;
                    }
                    return iCount2 - iCount1;
                }
            });
        }
        if (this.iSortingMode == SortingMode.ContributionRate) {
            Collections.sort(this.iProducts, new Comparator<SSProduct>(){

                @Override
                public int compare(SSProduct iProduct1, SSProduct iProduct2) {
                    BigDecimal iContributionRate1 = (BigDecimal)SSSaleReportPrinter.this.iContributionRate.get(iProduct1.getNumber());
                    BigDecimal iContributionRate2 = (BigDecimal)SSSaleReportPrinter.this.iContributionRate.get(iProduct2.getNumber());
                    if (iContributionRate1 == null) {
                        iContributionRate1 = new BigDecimal(0);
                    }
                    if (iContributionRate2 == null) {
                        iContributionRate2 = new BigDecimal(0);
                    }
                    if (SSSaleReportPrinter.this.iAscending) {
                        return iContributionRate1.compareTo(iContributionRate2);
                    }
                    return iContributionRate2.compareTo(iContributionRate1);
                }
            });
        }
        if (this.iSortingMode == SortingMode.AverageSellingPrice) {
            Collections.sort(this.iProducts, new Comparator<SSProduct>(){

                @Override
                public int compare(SSProduct iProduct1, SSProduct iProduct2) {
                    BigDecimal iAverageSellingPrice1 = (BigDecimal)SSSaleReportPrinter.this.iContribution.get(iProduct1.getNumber());
                    BigDecimal iAverageSellingPrice2 = (BigDecimal)SSSaleReportPrinter.this.iContribution.get(iProduct2.getNumber());
                    if (iAverageSellingPrice1 == null) {
                        iAverageSellingPrice1 = new BigDecimal(0);
                    }
                    if (iAverageSellingPrice2 == null) {
                        iAverageSellingPrice2 = new BigDecimal(0);
                    }
                    if (SSSaleReportPrinter.this.iAscending) {
                        return iAverageSellingPrice1.compareTo(iAverageSellingPrice2);
                    }
                    return iAverageSellingPrice2.compareTo(iAverageSellingPrice1);
                }
            });
        }
        iModel.setObjects(this.iProducts);
        return iModel;
    }

    /*
     * WARNING - void declaration
     */
    private void calculate() {
        this.iDays = SSDateMath.getDaysBetween(this.iFrom, this.iTo);
        this.iCount = new HashMap<String, Integer>();
        this.iContribution = new HashMap<String, BigDecimal>();
        this.iContributionRate = new HashMap<String, BigDecimal>();
        this.iAverageSellingPrice = new HashMap<String, BigDecimal>();
        this.iInprices = new HashMap<String, BigDecimal>();
        LinkedList<SSSupplierInvoice> iSupplierInvoices = new LinkedList<SSSupplierInvoice>(SSDB.getInstance().getSupplierInvoices());
        Collections.sort(iSupplierInvoices, new Comparator<SSSupplierInvoice>(){

            @Override
            public int compare(SSSupplierInvoice o1, SSSupplierInvoice o2) {
                return o2.getDate().compareTo(o1.getDate());
            }
        });
        for (SSSupplierInvoice sSSupplierInvoice : iSupplierInvoices) {
            if (!SSSupplierInvoiceMath.inPeriod(sSSupplierInvoice, this.iTo)) continue;
            for (SSSupplierInvoiceRow sSSupplierInvoiceRow : sSSupplierInvoice.getRows()) {
                if (sSSupplierInvoiceRow.getProductNr() == null) continue;
                SSProduct sSProduct = new SSProduct();
                sSProduct.setNumber(sSSupplierInvoiceRow.getProductNr());
                SSProduct sSProduct2 = SSDB.getInstance().getProduct(sSProduct);
                if (sSProduct2 == null || sSProduct2.isParcel() || this.iInprices.containsKey(sSProduct2.getNumber())) continue;
                BigDecimal bigDecimal = sSSupplierInvoiceRow.getUnitprice() == null ? new BigDecimal(0) : sSSupplierInvoiceRow.getUnitprice();
                BigDecimal iUnitFreight = sSSupplierInvoiceRow.getUnitFreight() == null ? new BigDecimal(0) : sSSupplierInvoiceRow.getUnitFreight();
                BigDecimal iInprice = SSSupplierInvoiceMath.convertToLocal(sSSupplierInvoice, bigDecimal.add(iUnitFreight));
                this.iInprices.put(sSProduct2.getNumber(), iInprice);
            }
        }
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        for (SSInvoice iInvoice : iInvoices) {
            if (!SSInvoiceMath.inPeriod(iInvoice, this.iFrom, this.iTo)) continue;
            for (SSSaleRow sSSaleRow : iInvoice.getRows()) {
                SSProduct sSProduct;
                if (sSSaleRow.getProductNr() == null || (sSProduct = SSDB.getInstance().getProduct(sSSaleRow.getProductNr())) == null || sSSaleRow.getQuantity() == null) continue;
                if (sSSaleRow.getSum() != null) {
                    if (this.iAverageSellingPrice.containsKey(sSProduct.getNumber())) {
                        this.iAverageSellingPrice.put(sSProduct.getNumber(), this.iAverageSellingPrice.get(sSProduct.getNumber()).add(SSInvoiceMath.convertToLocal(iInvoice, sSSaleRow.getSum())));
                    } else {
                        this.iAverageSellingPrice.put(sSProduct.getNumber(), SSInvoiceMath.convertToLocal(iInvoice, sSSaleRow.getSum()));
                    }
                }
                if (this.iCount.containsKey(sSProduct.getNumber())) {
                    this.iCount.put(sSProduct.getNumber(), this.iCount.get(sSProduct.getNumber()) + sSSaleRow.getQuantity());
                    continue;
                }
                this.iCount.put(sSProduct.getNumber(), sSSaleRow.getQuantity());
            }
        }
        List<SSCreditInvoice> list = SSDB.getInstance().getCreditInvoices();
        for (SSCreditInvoice sSCreditInvoice : list) {
            if (!SSInvoiceMath.inPeriod(sSCreditInvoice, this.iFrom, this.iTo)) continue;
            for (SSSaleRow sSSaleRow : sSCreditInvoice.getRows()) {
                SSProduct iProduct;
                if (sSSaleRow.getProductNr() == null || (iProduct = SSDB.getInstance().getProduct(sSSaleRow.getProductNr())) == null || sSSaleRow.getQuantity() == null) continue;
                if (sSSaleRow.getSum() != null) {
                    if (this.iAverageSellingPrice.containsKey(iProduct.getNumber())) {
                        this.iAverageSellingPrice.put(iProduct.getNumber(), this.iAverageSellingPrice.get(iProduct.getNumber()).subtract(sSSaleRow.getSum()));
                    } else {
                        this.iAverageSellingPrice.put(iProduct.getNumber(), sSSaleRow.getSum().negate());
                    }
                }
                if (this.iCount.containsKey(iProduct.getNumber())) {
                    this.iCount.put(iProduct.getNumber(), this.iCount.get(iProduct.getNumber()) + sSSaleRow.getQuantity() * -1);
                    continue;
                }
                this.iCount.put(iProduct.getNumber(), sSSaleRow.getQuantity() * -1);
            }
        }
        for (SSProduct sSProduct : this.iProducts) {
            if (sSProduct.isParcel()) {
                void var6_22;
                BigDecimal bigDecimal = new BigDecimal(0);
                for (SSProductRow iRow : sSProduct.getParcelRows()) {
                    SSProduct iRowProduct = SSDB.getInstance().getProduct(iRow.getProductNr());
                    if (iRowProduct == null || sSProduct.equals(iRowProduct)) continue;
                    Integer iQuantity = iRow.getQuantity();
                    if (iRowProduct == null || iQuantity == null) continue;
                    BigDecimal iInprice = this.iInprices.get(iRowProduct.getNumber());
                    if (iInprice == null) break;
                    BigDecimal bigDecimal2 = var6_22.add(iInprice.multiply(new BigDecimal(iQuantity)));
                }
                if (!this.iInprices.containsKey(sSProduct.getNumber())) {
                    this.iInprices.put(sSProduct.getNumber(), (BigDecimal)var6_22);
                }
            }
            if (!this.iInprices.containsKey(sSProduct.getNumber())) {
                this.iInprices.put(sSProduct.getNumber(), sSProduct.getStockPrice());
            }
            if (!this.iCount.containsKey(sSProduct.getNumber())) {
                this.iCount.put(sSProduct.getNumber(), 0);
            }
            if (this.iAverageSellingPrice.containsKey(sSProduct.getNumber()) && this.iCount.containsKey(sSProduct.getNumber())) {
                Integer n = this.iCount.get(sSProduct.getNumber());
                BigDecimal bigDecimal = this.iAverageSellingPrice.get(sSProduct.getNumber());
                if (n == null || n == 0) {
                    this.iAverageSellingPrice.put(sSProduct.getNumber(), sSProduct.getSellingPrice());
                } else {
                    BigDecimal bSoldCount = new BigDecimal(n);
                    BigDecimal iAverage = bigDecimal.divide(bSoldCount, new MathContext(10)).setScale(2, RoundingMode.HALF_UP);
                    this.iAverageSellingPrice.put(sSProduct.getNumber(), iAverage);
                }
            } else {
                this.iAverageSellingPrice.put(sSProduct.getNumber(), sSProduct.getSellingPrice());
            }
            if (sSProduct.getSellingPrice() == null || this.iInprices.get(sSProduct.getNumber()) == null) {
                this.iContribution.put(sSProduct.getNumber(), null);
            } else {
                this.iContribution.put(sSProduct.getNumber(), sSProduct.getSellingPrice().subtract(this.iInprices.get(sSProduct.getNumber())));
            }
            this.iContributionRate.put(sSProduct.getNumber(), SSProductMath.getContributionRate(sSProduct, this.iTo, this.iContribution.get(sSProduct.getNumber())));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSSaleReportPrinter");
        sb.append("{iAscending=").append(this.iAscending);
        sb.append(", iAverageSellingPrice=").append(this.iAverageSellingPrice);
        sb.append(", iContribution=").append(this.iContribution);
        sb.append(", iContributionRate=").append(this.iContributionRate);
        sb.append(", iCount=").append(this.iCount);
        sb.append(", iDays=").append(this.iDays);
        sb.append(", iFrom=").append(this.iFrom);
        sb.append(", iInprices=").append(this.iInprices);
        sb.append(", iProducts=").append(this.iProducts);
        sb.append(", iSortingMode=").append((Object)this.iSortingMode);
        sb.append(", iTo=").append(this.iTo);
        sb.append('}');
        return sb.toString();
    }

    public static enum SortingMode {
        Product(SSBundle.getBundle().getString("salereport.dialog.sort.product")),
        Period(SSBundle.getBundle().getString("salereport.dialog.sort.period")),
        ContributionRate(SSBundle.getBundle().getString("salereport.dialog.sort.contributionrate")),
        AverageSellingPrice(SSBundle.getBundle().getString("salereport.dialog.sort.averagesellingprice"));

        private String iDescription;

        private SortingMode(String iDescription) {
            this.iDescription = iDescription;
        }

        public String toString() {
            return this.iDescription;
        }
    }
}

