/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSSalevaluesPrinter
extends SSPrinter {
    private Date iFrom;
    private Date iTo;
    private List<SSMonth> iMonths;

    public SSSalevaluesPrinter(Date iFrom, Date iTo) {
        this.iFrom = iFrom;
        this.iTo = iTo;
        this.iMonths = SSMonth.splitYearIntoMonths(iFrom, iTo);
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("salevalues.jrxml");
        this.setDetail("salevalues.jrxml");
        this.setSummary("salevalues.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("salevalues.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iFrom);
        this.addParameter("dateTo", this.iTo);
        SSDefaultTableModel<SSMonth> iModel = new SSDefaultTableModel<SSMonth>(){

            @Override
            public Class getType() {
                return SSProduct.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSMonth iMonth = (SSMonth)this.getObject(rowIndex);
                SSNewCompany iCurrentCompany = SSDB.getInstance().getCurrentCompany();
                switch (columnIndex) {
                    case 0: {
                        value = iMonth.toString();
                        break;
                    }
                    case 1: {
                        value = iCurrentCompany.getTenderValueForMonth(iMonth);
                        break;
                    }
                    case 2: {
                        value = iCurrentCompany.getOrderValueForMonth(iMonth);
                        break;
                    }
                    case 3: {
                        value = iCurrentCompany.getInvoiceValueForMonth(iMonth);
                    }
                }
                return value;
            }
        };
        iModel.addColumn("month.name");
        iModel.addColumn("month.tender");
        iModel.addColumn("month.order");
        iModel.addColumn("month.invoice");
        iModel.setObjects(this.iMonths);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSSalevaluesPrinter");
        sb.append("{iFrom=").append(this.iFrom);
        sb.append(", iMonths=").append(this.iMonths);
        sb.append(", iTo=").append(this.iTo);
        sb.append('}');
        return sb.toString();
    }
}

