/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSSimpleStatementPrinter
extends SSPrinter {
    private Date iDateFrom;
    private Date iDateTo;
    private GroupPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSAccount> iAccounts;
    private Map<String, List<SSAccount>> iAccountsByReportCode;
    private Map<SSAccount, BigDecimal> iCreditMinusDebetSum;
    private Map<SSAccount, BigDecimal> iDebetMinusCreditSum;

    public SSSimpleStatementPrinter(Date iDateFrom, Date iDateTo) {
        this(SSDB.getInstance().getAccounts(), iDateFrom, iDateTo);
    }

    public SSSimpleStatementPrinter(List<SSAccount> iAccounts, Date iDateFrom, Date iDateTo) {
        this.iDateFrom = iDateFrom;
        this.iDateTo = iDateTo;
        this.iAccounts = iAccounts;
        this.setPageHeader("simplestatement.jrxml");
        this.setDetail("simplestatement.jrxml");
        this.setPageFooter("simplestatement.jrxml");
        this.setColumnCount(2);
        this.setColumnWidth(275);
        this.setColumnSpacing(5);
        this.calculate();
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("simplestatement.title");
    }

    private void calculate() {
        List<SSVoucher> iVouchers = SSVoucherMath.getVouchers(SSDB.getInstance().getVouchers(), this.iDateFrom, this.iDateTo);
        this.iCreditMinusDebetSum = SSVoucherMath.getCreditMinusDebetSum(iVouchers);
        this.iDebetMinusCreditSum = SSVoucherMath.getDebetMinusCreditSum(iVouchers);
        this.iAccountsByReportCode = new HashMap<String, List<SSAccount>>();
        for (SSAccount iAccount : this.iAccounts) {
            String iReportCode = iAccount.getReportCode();
            List<SSAccount> iAccountsForReportCode = this.iAccountsByReportCode.get(iReportCode);
            if (iAccountsForReportCode == null) {
                iAccountsForReportCode = new LinkedList<SSAccount>();
                this.iAccountsByReportCode.put(iReportCode, iAccountsForReportCode);
            }
            iAccountsForReportCode.add(iAccount);
        }
    }

    private BigDecimal getValueForGroup(String group, int number) {
        Map<SSAccount, BigDecimal> iValues;
        switch (number) {
            case 1: {
                iValues = this.iDebetMinusCreditSum;
                break;
            }
            case 2: {
                iValues = this.iDebetMinusCreditSum;
                break;
            }
            case 3: {
                iValues = this.iCreditMinusDebetSum;
                break;
            }
            case 4: {
                iValues = this.iCreditMinusDebetSum;
                break;
            }
            case 5: {
                iValues = this.iCreditMinusDebetSum;
                break;
            }
            case 6: {
                iValues = this.iCreditMinusDebetSum;
                break;
            }
            case 7: {
                iValues = this.iCreditMinusDebetSum;
                break;
            }
            case 8: {
                iValues = this.iCreditMinusDebetSum;
                break;
            }
            case 9: {
                iValues = this.iCreditMinusDebetSum;
                break;
            }
            case 10: {
                iValues = this.iDebetMinusCreditSum;
                break;
            }
            case 11: {
                iValues = this.iCreditMinusDebetSum;
                break;
            }
            default: {
                return new BigDecimal(0);
            }
        }
        if (group.equals("B11")) {
            return null;
        }
        if (group.equals("B12")) {
            return null;
        }
        if (group.equals("B10")) {
            BigDecimal iSumForAccounts = this.getSumForAccounts(iValues, group);
            iSumForAccounts = iSumForAccounts.add(this.getSumForAccounts(iValues, "U1", "U2", "U3", "U4"));
            return iSumForAccounts;
        }
        return this.getSumForAccounts(iValues, group);
    }

    private BigDecimal getSumForGroup(String group, int number) {
        if (group.equals("B9")) {
            return this.getSumForAccounts(this.iDebetMinusCreditSum, "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9");
        }
        if (group.equals("B16")) {
            return this.getSumForAccounts(this.iCreditMinusDebetSum, "B10", "B13", "B14", "B15", "B16", "U1", "U2", "U3", "U4");
        }
        return null;
    }

    private boolean getShowSeparatorForGroup(String group, int number) {
        return !group.equals("B5") && !group.equals("B10") && !group.equals("B11") && !group.equals("B12") && !group.equals("R4") && !group.equals("R8") && !group.equals("R10") && !group.equals("R11") && !group.equals("U4");
    }

    private int getSection(int group) {
        switch (group) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("date.from", this.iDateFrom);
        this.addParameter("date.to", this.iDateTo);
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.addParameter("company.name", iCompany.getName());
            this.addParameter("company.corporateid", iCompany.getCorporateID());
        }
        this.iPrinter = new GroupPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<Integer> iModel = new SSDefaultTableModel<Integer>(){

            @Override
            public Class getType() {
                return String.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Integer iNumber = (Integer)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = iNumber;
                        break;
                    }
                    case 1: {
                        value = SSSimpleStatementPrinter.this.getSection(iNumber);
                        break;
                    }
                    case 2: {
                        value = SSBundle.getBundle().getString("simplestatement.group." + iNumber);
                        break;
                    }
                    case 3: {
                        SSSimpleStatementPrinter.this.iPrinter.setGroup(iNumber);
                        SSSimpleStatementPrinter.this.iDataSource.reset();
                        value = SSSimpleStatementPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("group.number");
        iModel.addColumn("group.section");
        iModel.addColumn("group.description");
        iModel.addColumn("group.rows");
        iModel.add(1);
        iModel.add(2);
        iModel.add(7);
        iModel.add(8);
        iModel.add(3);
        iModel.add(4);
        iModel.add(5);
        iModel.add(6);
        iModel.add(9);
        iModel.add(10);
        iModel.add(11);
        return iModel;
    }

    private BigDecimal getSumForAccounts(Map<SSAccount, BigDecimal> iSums, String ... iReportCodes) {
        BigDecimal iSum = new BigDecimal(0);
        SSNewAccountingYear iYear = SSDB.getInstance().getCurrentYear();
        for (SSAccount iAccount : this.iAccounts) {
            if (!this.hasReportCode(iAccount, iReportCodes)) continue;
            BigDecimal iSumForAccount = iSums.get(iAccount);
            BigDecimal iInbalanceForAccount = iYear.getInBalance(iAccount);
            if (iSumForAccount != null) {
                iSum = iSum.add(iSumForAccount);
            }
            if (iInbalanceForAccount == null) continue;
            if (this.hasReportCode(iAccount, "B10", "B13", "B14", "B15", "B16", "U1", "U2", "U3", "U4")) {
                iSum = iSum.add(iInbalanceForAccount.multiply(new BigDecimal(-1)));
                continue;
            }
            iSum = iSum.add(iInbalanceForAccount);
        }
        return iSum;
    }

    private boolean hasReportCode(SSAccount iAccount, String ... iReportCodes) {
        String iReportCodeForAccount = iAccount.getReportCode();
        for (String iReportCode : iReportCodes) {
            if (!iReportCode.equals(iReportCodeForAccount)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSSimpleStatementPrinter");
        sb.append("{iAccounts=").append(this.iAccounts);
        sb.append(", iAccountsByReportCode=").append(this.iAccountsByReportCode);
        sb.append(", iCreditMinusDebetSum=").append(this.iCreditMinusDebetSum);
        sb.append(", iDataSource=").append(this.iDataSource);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iDebetMinusCreditSum=").append(this.iDebetMinusCreditSum);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class GroupPrinter
    extends SSPrinter {
        private SSDefaultTableModel<String> iModel;
        private Integer iGroup;

        public GroupPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setSize(250, 842);
            this.setColumnWidth(250);
            this.setDetail("simplestatement.group.jrxml");
            this.setSummary("simplestatement.group.jrxml");
            this.iModel = new SSDefaultTableModel<String>(){

                @Override
                public Class getType() {
                    return Integer.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    String iNumber = (String)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iNumber;
                            break;
                        }
                        case 1: {
                            value = SSBundle.getBundle().getString("simplestatement.group." + iNumber);
                            break;
                        }
                        case 2: {
                            value = SSSimpleStatementPrinter.this.getValueForGroup(iNumber, GroupPrinter.this.iGroup);
                            break;
                        }
                        case 3: {
                            value = SSBundle.getBundle().getString("simplestatement.group." + iNumber + ".sum");
                            break;
                        }
                        case 4: {
                            value = SSSimpleStatementPrinter.this.getSumForGroup(iNumber, GroupPrinter.this.iGroup);
                            break;
                        }
                        case 5: {
                            value = SSSimpleStatementPrinter.this.getShowSeparatorForGroup(iNumber, GroupPrinter.this.iGroup);
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("group.number");
            this.iModel.addColumn("group.description");
            this.iModel.addColumn("group.value");
            this.iModel.addColumn("group.sumtext");
            this.iModel.addColumn("group.sum");
            this.iModel.addColumn("group.showseparator");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setGroup(Integer iNumber) {
            this.iGroup = iNumber;
            LinkedList<String> iObjects = new LinkedList<String>();
            switch (iNumber) {
                case 1: {
                    iObjects.add("B1");
                    iObjects.add("B2");
                    iObjects.add("B3");
                    iObjects.add("B4");
                    iObjects.add("B5");
                    break;
                }
                case 2: {
                    iObjects.add("B6");
                    iObjects.add("B7");
                    iObjects.add("B8");
                    iObjects.add("B9");
                    break;
                }
                case 3: {
                    iObjects.add("B10");
                    break;
                }
                case 4: {
                    iObjects.add("B11");
                    break;
                }
                case 5: {
                    iObjects.add("B12");
                    break;
                }
                case 6: {
                    iObjects.add("B13");
                    iObjects.add("B14");
                    iObjects.add("B15");
                    iObjects.add("B16");
                    break;
                }
                case 7: {
                    iObjects.add("R1");
                    iObjects.add("R2");
                    iObjects.add("R3");
                    iObjects.add("R4");
                    break;
                }
                case 8: {
                    iObjects.add("R5");
                    iObjects.add("R6");
                    iObjects.add("R7");
                    iObjects.add("R8");
                    break;
                }
                case 9: {
                    iObjects.add("R9");
                    iObjects.add("R10");
                    break;
                }
                case 10: {
                    iObjects.add("R11");
                    break;
                }
                case 11: {
                    iObjects.add("U1");
                    iObjects.add("U2");
                    iObjects.add("U3");
                    iObjects.add("U4");
                }
            }
            this.iModel.setObjects((List<String>)iObjects);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSSimpleStatementPrinter.GroupPrinter");
            sb.append("{iGroup=").append(this.iGroup);
            sb.append(", iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

