/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;

public class SSSupplierListPrinter
extends SSPrinter {
    private List<SSSupplier> iSuppliers;

    public SSSupplierListPrinter() {
        this(SSDB.getInstance().getSuppliers());
    }

    public SSSupplierListPrinter(List<SSSupplier> iSuppliers) {
        this.iSuppliers = iSuppliers;
        this.setPageHeader("header.jrxml");
        this.setColumnHeader("supplierlist.jrxml");
        this.setDetail("supplierlist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("supplierlistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        SSDefaultTableModel<SSSupplier> iModel = new SSDefaultTableModel<SSSupplier>(){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String value = null;
                SSSupplier iSupplier = (SSSupplier)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iSupplier.getNumber();
                        break;
                    }
                    case 1: {
                        value = iSupplier.getName();
                        break;
                    }
                    case 2: {
                        value = iSupplier.getPhone1();
                        break;
                    }
                    case 3: {
                        value = iSupplier.getOurCustomerNr();
                        break;
                    }
                    case 4: {
                        value = iSupplier.getYourContact();
                    }
                }
                return value;
            }
        };
        iModel.addColumn("supplier.number");
        iModel.addColumn("supplier.name");
        iModel.addColumn("supplier.phone");
        iModel.addColumn("supplier.ourcustomernumber");
        iModel.addColumn("supplier.contact");
        Collections.sort(this.iSuppliers, new Comparator<SSSupplier>(){

            @Override
            public int compare(SSSupplier o1, SSSupplier o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        iModel.setObjects(this.iSuppliers);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSSupplierListPrinter");
        sb.append("{iSuppliers=").append(this.iSuppliers);
        sb.append('}');
        return sb.toString();
    }
}

