/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSSupplierRevenuePrinter
extends SSPrinter {
    private SSMonthlyDistributionPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSSupplier> iSuppliers;
    private Date iDateFrom;
    private Date iDateTo;
    private Map<String, Map<SSMonth, BigDecimal>> iSupplierRevenue;

    public SSSupplierRevenuePrinter(List<SSSupplier> pSuppliers, Date pFrom, Date pTo) {
        this.iSuppliers = pSuppliers;
        this.iDateFrom = SSDateMath.floor(pFrom);
        this.iDateTo = SSDateMath.ceil(pTo);
        this.calculate();
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("supplierrevenue.jrxml");
        this.setDetail("supplierrevenue.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("supplierrevenue.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.addParameter("dateFrom", this.iDateFrom);
        this.addParameter("dateTo", this.iDateTo);
        this.iPrinter = new SSMonthlyDistributionPrinter(this.iDateFrom, this.iDateTo);
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSSupplier> iModel = new SSDefaultTableModel<SSSupplier>(){

            @Override
            public Class getType() {
                return SSSupplier.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSSupplier iSupplier = (SSSupplier)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iSupplier.getNumber();
                        break;
                    }
                    case 1: {
                        value = iSupplier.getName();
                        break;
                    }
                    case 2: {
                        SSSupplierRevenuePrinter.this.iPrinter.setSupplier(iSupplier, (Map)SSSupplierRevenuePrinter.this.iSupplierRevenue.get(iSupplier.getNumber()));
                        SSSupplierRevenuePrinter.this.iDataSource.reset();
                        value = SSSupplierRevenuePrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("supplier.number");
        iModel.addColumn("supplier.description");
        iModel.addColumn("month.data");
        iModel.setObjects(this.iSuppliers);
        return iModel;
    }

    private void calculate() {
        this.iSupplierRevenue = new HashMap<String, Map<SSMonth, BigDecimal>>();
        List<SSSupplierInvoice> iSupplierInvoices = SSDB.getInstance().getSupplierInvoices();
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            Map<Object, Object> iRevenueInMonth;
            if (!iSupplierInvoice.getDate().after(this.iDateFrom) || !iSupplierInvoice.getDate().before(this.iDateTo)) continue;
            Calendar iCal = Calendar.getInstance();
            iCal.setTime(iSupplierInvoice.getDate());
            iCal.set(5, 1);
            Date iFrom = iCal.getTime();
            iCal.set(5, iCal.getActualMaximum(5));
            Date iTo = iCal.getTime();
            SSMonth iMonth = new SSMonth(iFrom, iTo);
            if (iSupplierInvoice.getSupplierNr() == null || SSSupplierInvoiceMath.getNetSum(iSupplierInvoice) == null) continue;
            BigDecimal iSum = SSSupplierInvoiceMath.convertToLocal(iSupplierInvoice, SSSupplierInvoiceMath.getNetSum(iSupplierInvoice));
            if (this.iSupplierRevenue.containsKey(iSupplierInvoice.getSupplierNr())) {
                iRevenueInMonth = this.iSupplierRevenue.get(iSupplierInvoice.getSupplierNr());
                if (iRevenueInMonth.containsKey(iMonth)) {
                    iRevenueInMonth.put(iMonth, ((BigDecimal)iRevenueInMonth.get(iMonth)).add(iSum));
                } else {
                    iRevenueInMonth.put(iMonth, iSum);
                }
            } else {
                iRevenueInMonth = new HashMap<SSMonth, BigDecimal>();
                iRevenueInMonth.put(iMonth, iSum);
            }
            this.iSupplierRevenue.put(iSupplierInvoice.getSupplierNr(), iRevenueInMonth);
        }
        List<SSSupplierCreditInvoice> iSupplierCreditInvoices = SSDB.getInstance().getSupplierCreditInvoices();
        for (SSSupplierCreditInvoice iSupplierCreditInvoice : iSupplierCreditInvoices) {
            Map<Object, Object> iRevenueInMonth;
            if (!iSupplierCreditInvoice.getDate().after(this.iDateFrom) || !iSupplierCreditInvoice.getDate().before(this.iDateTo)) continue;
            Calendar iCal = Calendar.getInstance();
            iCal.setTime(iSupplierCreditInvoice.getDate());
            iCal.set(5, 1);
            Date iFrom = iCal.getTime();
            iCal.set(5, iCal.getActualMaximum(5));
            Date iTo = iCal.getTime();
            SSMonth iMonth = new SSMonth(iFrom, iTo);
            if (iSupplierCreditInvoice.getSupplierNr() == null || SSSupplierInvoiceMath.getNetSum(iSupplierCreditInvoice) == null) continue;
            BigDecimal iSum = SSSupplierInvoiceMath.convertToLocal(iSupplierCreditInvoice, SSSupplierInvoiceMath.getNetSum(iSupplierCreditInvoice));
            if (this.iSupplierRevenue.containsKey(iSupplierCreditInvoice.getSupplierNr())) {
                iRevenueInMonth = this.iSupplierRevenue.get(iSupplierCreditInvoice.getSupplierNr());
                if (iRevenueInMonth.containsKey(iMonth)) {
                    iRevenueInMonth.put(iMonth, ((BigDecimal)iRevenueInMonth.get(iMonth)).subtract(iSum));
                } else {
                    iRevenueInMonth.put(iMonth, iSum.negate());
                }
            } else {
                iRevenueInMonth = new HashMap<SSMonth, BigDecimal>();
                iRevenueInMonth.put(iMonth, iSum.negate());
            }
            this.iSupplierRevenue.put(iSupplierCreditInvoice.getSupplierNr(), iRevenueInMonth);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSSupplierRevenuePrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iDateFrom=").append(this.iDateFrom);
        sb.append(", iDateTo=").append(this.iDateTo);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iSupplierRevenue=").append(this.iSupplierRevenue);
        sb.append(", iSuppliers=").append(this.iSuppliers);
        sb.append('}');
        return sb.toString();
    }

    private class SSMonthlyDistributionPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSMonth> iModel;
        private SSSupplier iSupplier;
        private Date iFrom;
        private Date iTo;
        private Map<SSMonth, BigDecimal> iRevenue;

        public SSMonthlyDistributionPrinter(Date pFrom, Date pTo) {
            this.iFrom = pFrom;
            this.iTo = pTo;
            this.setMargins(0, 0, 0, 0);
            this.setDetail("supplierrevenue.monthly.jrxml");
            this.setSummary("supplierrevenue.monthly.jrxml");
            this.iModel = new SSDefaultTableModel<SSMonth>(SSMonth.splitYearIntoMonths(this.iFrom, this.iTo)){

                @Override
                public Class getType() {
                    return SSMonth.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSMonth iMonth = (SSMonth)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iMonth.toString();
                            break;
                        }
                        case 1: {
                            value = iMonth.getName();
                            break;
                        }
                        case 2: {
                            if (SSMonthlyDistributionPrinter.this.iSupplier != null && SSMonthlyDistributionPrinter.this.iRevenue.containsKey(iMonth)) {
                                value = SSMonthlyDistributionPrinter.this.iRevenue.get(iMonth);
                                break;
                            }
                            value = new BigDecimal(0);
                            break;
                        }
                        case 3: {
                            value = iMonth.isBetween(SSMonthlyDistributionPrinter.this.iFrom, SSMonthlyDistributionPrinter.this.iTo);
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("month.date");
            this.iModel.addColumn("month.description");
            this.iModel.addColumn("month.value");
            this.iModel.addColumn("month.visible");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setSupplier(SSSupplier pSupplier, Map<SSMonth, BigDecimal> iMap) {
            this.iSupplier = pSupplier;
            this.iRevenue = iMap;
            if (this.iRevenue == null) {
                this.iRevenue = new HashMap<SSMonth, BigDecimal>();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSSupplierRevenuePrinter.SSMonthlyDistributionPrinter");
            sb.append("{iFrom=").append(this.iFrom);
            sb.append(", iModel=").append(this.iModel);
            sb.append(", iRevenue=").append(this.iRevenue);
            sb.append(", iSupplier=").append(this.iSupplier);
            sb.append(", iTo=").append(this.iTo);
            sb.append('}');
            return sb.toString();
        }
    }
}

