/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSTenderMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSTenderListPrinter
extends SSPrinter {
    private SSTenderRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;
    private List<SSTender> iTenders;

    public SSTenderListPrinter() {
        this(SSDB.getInstance().getTenders());
    }

    public SSTenderListPrinter(List<SSTender> iTenders) {
        this.iTenders = iTenders;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("tenderlist.jrxml");
        this.setDetail("tenderlist.jrxml");
        this.setSummary("tenderlist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("tenderlistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSTenderRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSTender> iModel = new SSDefaultTableModel<SSTender>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSTender iTender = (SSTender)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iTender.getNumber();
                        break;
                    }
                    case 1: {
                        value = iTender.getCustomerNr();
                        break;
                    }
                    case 2: {
                        value = iTender.getCustomerName();
                        break;
                    }
                    case 3: {
                        value = this.iFormat.format(iTender.getDate());
                        break;
                    }
                    case 4: {
                        value = iTender.getCurrency() == null ? null : iTender.getCurrency().getName();
                        break;
                    }
                    case 5: {
                        SSTenderListPrinter.this.iPrinter.setTender(iTender);
                        SSTenderListPrinter.this.iDataSource.reset();
                        value = SSTenderListPrinter.this.iDataSource;
                        break;
                    }
                    case 6: {
                        BigDecimal iSum = new BigDecimal(0);
                        iSum = iSum.add(SSTenderMath.getNetSum(iTender).multiply(iTender.getCurrencyRate()));
                        value = iSum;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("tender.number");
        iModel.addColumn("tender.customernr");
        iModel.addColumn("tender.customername");
        iModel.addColumn("tender.date");
        iModel.addColumn("tender.currency");
        iModel.addColumn("tender.rows");
        iModel.addColumn("tender.sum");
        Collections.sort(this.iTenders, new Comparator<SSTender>(){

            @Override
            public int compare(SSTender o1, SSTender o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iTenders);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSTenderListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iTenders=").append(this.iTenders);
        sb.append('}');
        return sb.toString();
    }

    private class SSTenderRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSSaleRow> iModel;

        public SSTenderRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("tenderlist.row.jrxml");
            this.setSummary("tenderlist.row.jrxml");
            this.iModel = new SSDefaultTableModel<SSSaleRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSaleRow iRow = (SSSaleRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getQuantity();
                            break;
                        }
                        case 3: {
                            value = iRow.getUnit() == null ? null : iRow.getUnit().getName();
                            break;
                        }
                        case 4: {
                            value = iRow.getUnitprice();
                            break;
                        }
                        case 5: {
                            value = iRow.getDiscount();
                            break;
                        }
                        case 6: {
                            value = iRow.getSum();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("row.number");
            this.iModel.addColumn("row.description");
            this.iModel.addColumn("row.count");
            this.iModel.addColumn("row.unit");
            this.iModel.addColumn("row.unitprice");
            this.iModel.addColumn("row.discount");
            this.iModel.addColumn("row.sum");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setTender(SSTender iTender) {
            this.iModel.setObjects(iTender.getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSTenderListPrinter.SSTenderRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

