/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSVoucherListPrinter
extends SSPrinter {
    private List<SSVoucher> iVouchers;
    private SSVoucherRowPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;

    public SSVoucherListPrinter(List<SSVoucher> pVouchers) {
        this.iVouchers = pVouchers;
        this.setPageHeader("header_period.jrxml");
        this.setDetail("voucherlist.jrxml");
        this.setColumnHeader("voucherlist.jrxml");
        this.setSummary("voucherlist.jrxml");
    }

    @Override
    public String getTitle() {
        return SSBundle.getBundle().getString("voucherlistreport.title");
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSVoucherRowPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        SSDefaultTableModel<SSVoucher> iModel = new SSDefaultTableModel<SSVoucher>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSVoucher iVoucher = (SSVoucher)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iVoucher.getNumber();
                        break;
                    }
                    case 1: {
                        value = iVoucher.getDate() == null ? null : this.iFormat.format(iVoucher.getDate());
                        break;
                    }
                    case 2: {
                        value = iVoucher.getDescription();
                        break;
                    }
                    case 3: {
                        value = SSVoucherMath.getDebetSum(iVoucher);
                        break;
                    }
                    case 4: {
                        value = SSVoucherMath.getCreditSum(iVoucher);
                        break;
                    }
                    case 5: {
                        SSVoucherListPrinter.this.iPrinter.setRows(iVoucher.getRows());
                        SSVoucherListPrinter.this.iDataSource.reset();
                        value = SSVoucherListPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("voucher.number");
        iModel.addColumn("voucher.date");
        iModel.addColumn("voucher.description");
        iModel.addColumn("voucher.debet");
        iModel.addColumn("voucher.credet");
        iModel.addColumn("voucher.rows");
        Collections.sort(this.iVouchers, new Comparator<SSVoucher>(){

            @Override
            public int compare(SSVoucher o1, SSVoucher o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        iModel.setObjects(this.iVouchers);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.SSVoucherListPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iVouchers=").append(this.iVouchers);
        sb.append('}');
        return sb.toString();
    }

    private class SSVoucherRowPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSVoucherRow> iModel;

        public SSVoucherRowPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("voucherlist.rows.jrxml");
            this.setSummary("voucherlist.rows.jrxml");
            this.iModel = new SSDefaultTableModel<SSVoucherRow>(){
                DateFormat iFormat = DateFormat.getDateInstance(3);

                @Override
                public Class getType() {
                    return SSVoucherRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Comparable<BigDecimal> value = null;
                    SSVoucherRow iRow = (SSVoucherRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getNumber();
                            break;
                        }
                        case 1: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getDebet();
                            break;
                        }
                        case 3: {
                            value = iRow.getCredit();
                            break;
                        }
                        case 4: {
                            value = iRow.getProject() == null ? null : iRow.getProject().getNumber();
                            break;
                        }
                        case 5: {
                            value = iRow.getResultUnit() == null ? null : iRow.getResultUnit().getNumber();
                            break;
                        }
                        case 6: {
                            value = iRow.isAdded();
                            break;
                        }
                        case 7: {
                            value = iRow.isCrossed();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("voucherrow.account");
            this.iModel.addColumn("voucherrow.description");
            this.iModel.addColumn("voucherrow.debet");
            this.iModel.addColumn("voucherrow.credet");
            this.iModel.addColumn("voucherrow.project");
            this.iModel.addColumn("voucherrow.resultunit");
            this.iModel.addColumn("voucherrow.isadded");
            this.iModel.addColumn("voucherrow.iscrossed");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setRows(List<SSVoucherRow> iRows) {
            this.iModel.setObjects(iRows);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.SSVoucherListPrinter.SSVoucherRowPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

