/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.journals;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSCreditinvoicejournalPrinter
extends SSPrinter {
    private Integer iNumber;
    private List<SSCreditInvoice> iCreditInvoices;
    private SSVoucherPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;

    public SSCreditinvoicejournalPrinter(List<SSCreditInvoice> iCreditInvoices, Integer iNumber, Date iDate) {
        this.iCreditInvoices = iCreditInvoices;
        this.iNumber = iNumber;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("journals/creditinvoicejournal.jrxml");
        this.setDetail("journals/creditinvoicejournal.jrxml");
        this.setSummary("journals/creditinvoicejournal.jrxml");
        this.addParameter("periodTitle", this.iBundle.getString("creditinvoicejournal.periodtitle"));
        this.addParameter("periodText", iDate);
    }

    @Override
    public String getTitle() {
        return String.format(this.iBundle.getString("creditinvoicejournal.title"), this.iNumber);
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSVoucherPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        Collections.sort(this.iCreditInvoices, new Comparator<SSInvoice>(){

            @Override
            public int compare(SSInvoice o1, SSInvoice o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        SSDefaultTableModel<SSCreditInvoice> iModel = new SSDefaultTableModel<SSCreditInvoice>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSCreditInvoice iCreditInvoice = (SSCreditInvoice)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iCreditInvoice.getNumber();
                        break;
                    }
                    case 1: {
                        value = iCreditInvoice.getCustomerNr();
                        break;
                    }
                    case 2: {
                        value = iCreditInvoice.getCustomerName();
                        break;
                    }
                    case 3: {
                        value = iCreditInvoice.getDate() == null ? null : this.iFormat.format(iCreditInvoice.getDate());
                        break;
                    }
                    case 4: {
                        value = iCreditInvoice.getCurrency() == null ? null : iCreditInvoice.getCurrency().getName();
                        break;
                    }
                    case 5: {
                        value = iCreditInvoice.getCurrencyRate();
                        break;
                    }
                    case 6: {
                        value = SSInvoiceMath.getTotalSum(iCreditInvoice);
                        break;
                    }
                    case 7: {
                        value = SSInvoiceMath.getTotalTaxSum(iCreditInvoice);
                        break;
                    }
                    case 8: {
                        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(iCreditInvoice);
                        value = SSInvoiceMath.convertToLocal(iCreditInvoice, iTotalSum);
                        break;
                    }
                    case 9: {
                        SSCreditinvoicejournalPrinter.this.iPrinter.setInvoice(iCreditInvoice);
                        SSCreditinvoicejournalPrinter.this.iDataSource.reset();
                        value = SSCreditinvoicejournalPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("creditinvoice.number");
        iModel.addColumn("creditinvoice.customernr");
        iModel.addColumn("creditinvoice.customername");
        iModel.addColumn("creditinvoice.date");
        iModel.addColumn("creditinvoice.currency");
        iModel.addColumn("creditinvoice.currencyrate");
        iModel.addColumn("creditinvoice.sum");
        iModel.addColumn("creditinvoice.tax");
        iModel.addColumn("creditinvoice.localsum");
        iModel.addColumn("journal.rows");
        iModel.setObjects(this.iCreditInvoices);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.journals.SSCreditinvoicejournalPrinter");
        sb.append("{iCreditInvoices=").append(this.iCreditInvoices);
        sb.append(", iDataSource=").append(this.iDataSource);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSVoucherPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSVoucherRow> iModel;

        public SSVoucherPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("journals/creditinvoicejournal.rows.jrxml");
            this.iModel = new SSDefaultTableModel<SSVoucherRow>(){
                DateFormat iFormat = DateFormat.getDateInstance(3);

                @Override
                public Class getType() {
                    return SSVoucherRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    BigDecimal value = null;
                    SSVoucherRow iRow = (SSVoucherRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getNumber();
                            break;
                        }
                        case 1: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getDebet();
                            break;
                        }
                        case 3: {
                            value = iRow.getCredit();
                            break;
                        }
                        case 4: {
                            value = iRow.getProject() == null ? null : iRow.getProject().getNumber();
                            break;
                        }
                        case 5: {
                            value = iRow.getResultUnit() == null ? null : iRow.getResultUnit().getNumber();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("row.account");
            this.iModel.addColumn("row.description");
            this.iModel.addColumn("row.debet");
            this.iModel.addColumn("row.credet");
            this.iModel.addColumn("row.project");
            this.iModel.addColumn("row.resultunit");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setInvoice(SSCreditInvoice iCreditInvoice) {
            this.iModel.setObjects(iCreditInvoice.getVoucher().getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.journals.SSCreditinvoicejournalPrinter.SSVoucherPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

