/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.journals;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSInvoicejournalPrinter
extends SSPrinter {
    private Integer iNumber;
    private List<SSInvoice> iInvoices;
    private SSVoucherPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;

    public SSInvoicejournalPrinter(List<SSInvoice> iInvoices, Integer iNumber, Date iDate) {
        this.iInvoices = iInvoices;
        this.iNumber = iNumber;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("journals/invoicejournal.jrxml");
        this.setDetail("journals/invoicejournal.jrxml");
        this.setSummary("journals/invoicejournal.jrxml");
        this.addParameter("periodTitle", this.iBundle.getString("invoicejournal.periodtitle"));
        this.addParameter("periodText", iDate);
    }

    @Override
    public String getTitle() {
        return String.format(this.iBundle.getString("invoicejournal.title"), this.iNumber);
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSVoucherPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        Collections.sort(this.iInvoices, new Comparator<SSInvoice>(){

            @Override
            public int compare(SSInvoice o1, SSInvoice o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        SSDefaultTableModel<SSInvoice> iModel = new SSDefaultTableModel<SSInvoice>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSInvoice iInvoice = (SSInvoice)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iInvoice.getNumber();
                        break;
                    }
                    case 1: {
                        value = iInvoice.getCustomerNr();
                        break;
                    }
                    case 2: {
                        value = iInvoice.getCustomerName();
                        break;
                    }
                    case 3: {
                        value = iInvoice.getDate() == null ? null : this.iFormat.format(iInvoice.getDate());
                        break;
                    }
                    case 4: {
                        value = iInvoice.getCurrency() == null ? null : iInvoice.getCurrency().getName();
                        break;
                    }
                    case 5: {
                        value = iInvoice.getCurrencyRate();
                        break;
                    }
                    case 6: {
                        value = SSInvoiceMath.getTotalSum(iInvoice);
                        break;
                    }
                    case 7: {
                        value = SSInvoiceMath.getTotalTaxSum(iInvoice);
                        break;
                    }
                    case 8: {
                        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(iInvoice);
                        value = SSInvoiceMath.convertToLocal(iInvoice, iTotalSum);
                        break;
                    }
                    case 9: {
                        SSInvoicejournalPrinter.this.iPrinter.setInvoice(iInvoice);
                        SSInvoicejournalPrinter.this.iDataSource.reset();
                        value = SSInvoicejournalPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("invoice.number");
        iModel.addColumn("invoice.customernr");
        iModel.addColumn("invoice.customername");
        iModel.addColumn("invoice.date");
        iModel.addColumn("invoice.currency");
        iModel.addColumn("invoice.currencyrate");
        iModel.addColumn("invoice.sum");
        iModel.addColumn("invoice.tax");
        iModel.addColumn("invoice.localsum");
        iModel.addColumn("journal.rows");
        iModel.setObjects(this.iInvoices);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.journals.SSInvoicejournalPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iInvoices=").append(this.iInvoices);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSVoucherPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSVoucherRow> iModel;

        public SSVoucherPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("journals/invoicejournal.rows.jrxml");
            this.iModel = new SSDefaultTableModel<SSVoucherRow>(){
                DateFormat iFormat = DateFormat.getDateInstance(3);

                @Override
                public Class getType() {
                    return SSVoucherRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    BigDecimal value = null;
                    SSVoucherRow iRow = (SSVoucherRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getNumber();
                            break;
                        }
                        case 1: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getDebet();
                            break;
                        }
                        case 3: {
                            value = iRow.getCredit();
                            break;
                        }
                        case 4: {
                            value = iRow.getProject() == null ? null : iRow.getProject().getNumber();
                            break;
                        }
                        case 5: {
                            value = iRow.getResultUnit() == null ? null : iRow.getResultUnit().getNumber();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("row.account");
            this.iModel.addColumn("row.description");
            this.iModel.addColumn("row.debet");
            this.iModel.addColumn("row.credet");
            this.iModel.addColumn("row.project");
            this.iModel.addColumn("row.resultunit");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setInvoice(SSInvoice iInvoice) {
            this.iModel.setObjects(iInvoice.getVoucher().getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.journals.SSInvoicejournalPrinter.SSVoucherPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

