/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.journals;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSOutpaymentMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource;

public class SSOutpaymentjournalPrinter
extends SSPrinter {
    private Integer iNumber;
    private List<SSOutpayment> iOutpayments;
    private SSVoucherPrinter iPrinter;
    private SSDefaultJasperDataSource iDataSource;

    public SSOutpaymentjournalPrinter(List<SSOutpayment> iOutpayments, Integer iNumber, Date iDate) {
        this.iOutpayments = iOutpayments;
        this.iNumber = iNumber;
        this.setPageHeader("header_period.jrxml");
        this.setColumnHeader("journals/outpaymentjournal.jrxml");
        this.setDetail("journals/outpaymentjournal.jrxml");
        this.setSummary("journals/outpaymentjournal.jrxml");
        this.addParameter("periodTitle", this.iBundle.getString("outpaymentjournal.periodtitle"));
        this.addParameter("periodText", iDate);
    }

    @Override
    public String getTitle() {
        return String.format(this.iBundle.getString("outpaymentjournal.title"), this.iNumber);
    }

    @Override
    protected SSDefaultTableModel getModel() {
        this.iPrinter = new SSVoucherPrinter();
        this.iPrinter.generateReport();
        this.addParameter("Report", this.iPrinter.getReport());
        this.addParameter("Parameters", this.iPrinter.getParameters());
        this.iDataSource = new SSDefaultJasperDataSource(this.iPrinter.getModel());
        Collections.sort(this.iOutpayments, new Comparator<SSOutpayment>(){

            @Override
            public int compare(SSOutpayment o1, SSOutpayment o2) {
                return o1.getNumber() - o2.getNumber();
            }
        });
        SSDefaultTableModel<SSOutpayment> iModel = new SSDefaultTableModel<SSOutpayment>(){
            DateFormat iFormat = DateFormat.getDateInstance(3);

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = null;
                SSOutpayment iOutpayment = (SSOutpayment)this.getObject(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        value = iOutpayment.getNumber();
                        break;
                    }
                    case 1: {
                        value = iOutpayment.getText();
                        break;
                    }
                    case 2: {
                        value = iOutpayment.getDate();
                        break;
                    }
                    case 3: {
                        value = SSOutpaymentMath.getSum(iOutpayment);
                        break;
                    }
                    case 4: {
                        SSOutpaymentjournalPrinter.this.iPrinter.setOutpayment(iOutpayment);
                        SSOutpaymentjournalPrinter.this.iDataSource.reset();
                        value = SSOutpaymentjournalPrinter.this.iDataSource;
                    }
                }
                return value;
            }
        };
        iModel.addColumn("outpayment.number");
        iModel.addColumn("outpayment.text");
        iModel.addColumn("outpayment.date");
        iModel.addColumn("outpayment.sum");
        iModel.addColumn("journal.rows");
        iModel.setObjects(this.iOutpayments);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.journals.SSOutpaymentjournalPrinter");
        sb.append("{iDataSource=").append(this.iDataSource);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iOutpayments=").append(this.iOutpayments);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append('}');
        return sb.toString();
    }

    private class SSVoucherPrinter
    extends SSPrinter {
        private SSDefaultTableModel<SSVoucherRow> iModel;

        public SSVoucherPrinter() {
            this.setMargins(0, 0, 0, 0);
            this.setDetail("journals/outpaymentjournal.rows.jrxml");
            this.iModel = new SSDefaultTableModel<SSVoucherRow>(){
                DateFormat iFormat = DateFormat.getDateInstance(3);

                @Override
                public Class getType() {
                    return SSVoucherRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    BigDecimal value = null;
                    SSVoucherRow iRow = (SSVoucherRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getNumber();
                            break;
                        }
                        case 1: {
                            value = iRow.getAccount() == null ? null : iRow.getAccount().getDescription();
                            break;
                        }
                        case 2: {
                            value = iRow.getDebet();
                            break;
                        }
                        case 3: {
                            value = iRow.getCredit();
                            break;
                        }
                        case 4: {
                            value = iRow.getProject() == null ? null : iRow.getProject().getNumber();
                            break;
                        }
                        case 5: {
                            value = iRow.getResultUnit() == null ? null : iRow.getResultUnit().getNumber();
                        }
                    }
                    return value;
                }
            };
            this.iModel.addColumn("row.account");
            this.iModel.addColumn("row.description");
            this.iModel.addColumn("row.debet");
            this.iModel.addColumn("row.credet");
            this.iModel.addColumn("row.project");
            this.iModel.addColumn("row.resultunit");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            return this.iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }

        public void setOutpayment(SSOutpayment iOutpayment) {
            this.iModel.setObjects(iOutpayment.getVoucher().getRows());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.print.report.journals.SSOutpaymentjournalPrinter.SSVoucherPrinter");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

