/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.sales;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSSalePrinterUtils;

public class SSCreditinvoicePrinter
extends SSPrinter {
    private SSCreditInvoice iCreditInvoice;
    private Locale iLocale;

    public SSCreditinvoicePrinter(SSCreditInvoice iInvoice, Locale iLocale) {
        this.iCreditInvoice = iInvoice;
        this.iLocale = iLocale;
        ResourceBundle iBundle = ResourceBundle.getBundle("reports.creditinvoicereport", iLocale);
        this.setBundle(iBundle);
        this.setLocale(iLocale);
        this.setMargins(0, 0, 0, 0);
        this.setPageHeader("sales/sale.header.jrxml");
        this.setPageFooter("sales/sale.footer.jrxml");
        this.setDetail("sales/creditinvoice.jrxml");
        this.setColumnHeader("sales/creditinvoice.jrxml");
        this.addParameters();
    }

    @Override
    public String getTitle() {
        this.addParameter("title.date", this.iBundle.getString("creditinvoicereport.title.date"));
        this.addParameter("title.number", this.iBundle.getString("creditinvoicereport.title.number"));
        return this.iBundle.getString("creditinvoicereport.title");
    }

    private void addParameters() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSCustomer iCustomer = this.iCreditInvoice.getCustomer(SSDB.getInstance().getCustomers());
        SSSalePrinterUtils.addParametersForCompany(iCompany, this);
        this.addParameter("number", this.iCreditInvoice.getNumber());
        this.addParameter("date", this.iCreditInvoice.getDate());
        this.addParameter("text", this.iCreditInvoice.getText());
        this.addParameter("creditinvoice.hasdiscount", SSInvoiceMath.hasDiscount(this.iCreditInvoice));
        this.addParameter("creditinvoice.deliveryadress.name", this.iCreditInvoice.getDeliveryAddress().getName());
        this.addParameter("creditinvoice.deliveryadress.address1", this.iCreditInvoice.getDeliveryAddress().getAddress1());
        this.addParameter("creditinvoice.deliveryadress.address2", this.iCreditInvoice.getDeliveryAddress().getAddress2());
        this.addParameter("creditinvoice.deliveryadress.zipcode", this.iCreditInvoice.getDeliveryAddress().getZipCode());
        this.addParameter("creditinvoice.deliveryadress.city", this.iCreditInvoice.getDeliveryAddress().getCity());
        this.addParameter("creditinvoice.deliveryadress.country", this.iCreditInvoice.getDeliveryAddress().getCountry());
        this.addParameter("creditinvoice.invoiceadress.name", this.iCreditInvoice.getInvoiceAddress().getName());
        this.addParameter("creditinvoice.invoiceadress.address1", this.iCreditInvoice.getInvoiceAddress().getAddress1());
        this.addParameter("creditinvoice.invoiceadress.address2", this.iCreditInvoice.getInvoiceAddress().getAddress2());
        this.addParameter("creditinvoice.invoiceadress.zipcode", this.iCreditInvoice.getInvoiceAddress().getZipCode());
        this.addParameter("creditinvoice.invoiceadress.city", this.iCreditInvoice.getInvoiceAddress().getCity());
        this.addParameter("creditinvoice.invoiceadress.country", this.iCreditInvoice.getInvoiceAddress().getCountry());
        SSInvoice iInvoice = this.iCreditInvoice.getCrediting();
        this.addParameter("creditinvoice.ourcontact", this.iCreditInvoice.getOurContactPerson());
        this.addParameter("creditinvoice.deliveryterm", this.iCreditInvoice.getDeliveryTerm(), true);
        this.addParameter("creditinvoice.deliveryway", this.iCreditInvoice.getDeliveryWay(), true);
        this.addParameter("creditinvoice.paymentterm", this.iCreditInvoice.getPaymentTerm(), true);
        this.addParameter("creditinvoice.delayinterest", this.iCreditInvoice.getDelayInterest(), true);
        this.addParameter("creditinvoice.currency", this.iCreditInvoice.getCurrency(), true);
        this.addParameter("creditinvoice.customernr", this.iCreditInvoice.getCustomerNr());
        this.addParameter("creditinvoice.yourcontact", this.iCreditInvoice.getYourContactPerson());
        this.addParameter("creditinvoice.yourordernumber", this.iCreditInvoice.getYourOrderNumber());
        this.addParameter("creditinvoice.paymentday", this.iCreditInvoice.getDueDate());
        if (iInvoice != null && iInvoice.getOCRNumber() != null) {
            this.addParameter("creditinvoice.invoicenumber", iInvoice.getOCRNumber());
        } else {
            this.addParameter("creditinvoice.invoicenumber", this.iCreditInvoice.getCreditingNr(), true);
        }
        this.addParameter("creditinvoice.taxrate1", this.iCreditInvoice.getTaxRate1().toString());
        this.addParameter("creditinvoice.taxrate2", this.iCreditInvoice.getTaxRate2().toString());
        this.addParameter("creditinvoice.taxrate3", this.iCreditInvoice.getTaxRate3().toString());
        if (iCustomer != null) {
            this.addParameter("creditinvoice.vatnumber", iCustomer.getVATNumber());
        }
        BigDecimal iNetSum = SSInvoiceMath.getNetSum(this.iCreditInvoice);
        Map<SSTaxCode, BigDecimal> iTaxSum = SSInvoiceMath.getTaxSum(this.iCreditInvoice);
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(this.iCreditInvoice);
        BigDecimal iRounding = SSInvoiceMath.getRounding(this.iCreditInvoice);
        this.addParameter("creditinvoice.netsum", iNetSum);
        this.addParameter("creditinvoice.taxsum1", iTaxSum.get(SSTaxCode.TAXRATE_1));
        this.addParameter("creditinvoice.taxsum2", iTaxSum.get(SSTaxCode.TAXRATE_2));
        this.addParameter("creditinvoice.taxsum3", iTaxSum.get(SSTaxCode.TAXRATE_3));
        this.addParameter("creditinvoice.rounding", iRounding);
        this.addParameter("creditinvoice.totalsum", iTotalSum);
    }

    @Override
    protected SSDefaultTableModel getModel() {
        final SSRowReport iPrinter = new SSRowReport();
        iPrinter.setBundle(this.iBundle);
        iPrinter.setLocale(this.iLocale);
        iPrinter.generateReport();
        this.addParameter("subreport.report", iPrinter.getReport());
        this.addParameter("subreport.parameters", iPrinter.getParameters());
        this.addParameter("subreport.datasource", iPrinter.getDataSource());
        SSDefaultTableModel<SSInvoice> iModel = new SSDefaultTableModel<SSInvoice>(){

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                iPrinter.getDataSource().reset();
                return iPrinter.getDataSource();
            }
        };
        iModel.addColumn("subreport.datasource");
        iModel.setObjects(this.iCreditInvoice);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.sales.SSCreditinvoicePrinter");
        sb.append("{iCreditInvoice=").append(this.iCreditInvoice);
        sb.append(", iLocale=").append(this.iLocale);
        sb.append('}');
        return sb.toString();
    }

    private class SSRowReport
    extends SSPrinter {
        public SSRowReport() {
            this.setMargins(0, 0, 0, 0);
            this.setColumnHeader("sales/creditinvoice.rows.jrxml");
            this.setDetail("sales/creditinvoice.rows.jrxml");
            this.setPageFooter("sales/creditinvoice.rows.jrxml");
            this.setLastPageFooter("sales/creditinvoice.rows.jrxml");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            SSDefaultTableModel<SSSaleRow> iModel = new SSDefaultTableModel<SSSaleRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSaleRow iRow = (SSSaleRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getDescription(SSCreditinvoicePrinter.this.iLocale);
                            break;
                        }
                        case 2: {
                            value = iRow.getQuantity();
                            break;
                        }
                        case 3: {
                            value = iRow.getUnit() == null ? null : iRow.getUnit().getName();
                            break;
                        }
                        case 4: {
                            value = iRow.getUnitprice();
                            break;
                        }
                        case 5: {
                            value = iRow.getDiscount();
                            break;
                        }
                        case 6: {
                            value = iRow.getSum();
                        }
                    }
                    return value;
                }
            };
            iModel.addColumn("row.number");
            iModel.addColumn("row.description");
            iModel.addColumn("row.count");
            iModel.addColumn("row.unit");
            iModel.addColumn("row.unitprice");
            iModel.addColumn("row.discount");
            iModel.addColumn("row.sum");
            iModel.setObjects(SSCreditinvoicePrinter.this.iCreditInvoice.getRows());
            return iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }
    }
}

