/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.sales;

import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSSalePrinterUtils;

public class SSDeliverynotePrinter
extends SSPrinter {
    private SSOrder iOrder;
    private boolean iHideUnitprice;
    private Locale iLocale;

    public SSDeliverynotePrinter(SSOrder iOrder, Locale iLocale) {
        this.iOrder = iOrder;
        this.iLocale = iLocale;
        this.iHideUnitprice = iOrder.getHideUnitprice();
        ResourceBundle iBundle = ResourceBundle.getBundle("reports.deliverynotereport", iLocale);
        this.setBundle(iBundle);
        this.setLocale(iLocale);
        this.setMargins(0, 0, 0, 0);
        this.setPageHeader("sales/sale.header.jrxml");
        this.setPageFooter("sales/sale.footer.jrxml");
        if (!this.iHideUnitprice) {
            this.setDetail("sales/deliverynote.jrxml");
            this.setColumnHeader("sales/deliverynote.jrxml");
        } else {
            this.setDetail("sales/deliverynote2.jrxml");
            this.setColumnHeader("sales/deliverynote2.jrxml");
        }
        this.addParameters();
    }

    @Override
    public String getTitle() {
        this.addParameter("title.date", this.iBundle.getString("deliverynotereport.title.date"));
        this.addParameter("title.number", this.iBundle.getString("deliverynotereport.title.number"));
        return this.iBundle.getString("deliverynotereport.title");
    }

    private void addParameters() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSSalePrinterUtils.addParametersForCompany(iCompany, this);
        this.addParameter("number", this.iOrder.getNumber());
        this.addParameter("date", this.iOrder.getDate());
        this.addParameter("text", this.iOrder.getText());
        this.addParameter("order.deliveryadress.name", this.iOrder.getDeliveryAddress().getName());
        this.addParameter("order.deliveryadress.address1", this.iOrder.getDeliveryAddress().getAddress1());
        this.addParameter("order.deliveryadress.address2", this.iOrder.getDeliveryAddress().getAddress2());
        this.addParameter("order.deliveryadress.zipcode", this.iOrder.getDeliveryAddress().getZipCode());
        this.addParameter("order.deliveryadress.city", this.iOrder.getDeliveryAddress().getCity());
        this.addParameter("order.deliveryadress.country", this.iOrder.getDeliveryAddress().getCountry());
        this.addParameter("order.invoiceadress.name", this.iOrder.getInvoiceAddress().getName());
        this.addParameter("order.invoiceadress.address1", this.iOrder.getInvoiceAddress().getAddress1());
        this.addParameter("order.invoiceadress.address2", this.iOrder.getInvoiceAddress().getAddress2());
        this.addParameter("order.invoiceadress.zipcode", this.iOrder.getInvoiceAddress().getZipCode());
        this.addParameter("order.invoiceadress.city", this.iOrder.getInvoiceAddress().getCity());
        this.addParameter("order.invoiceadress.country", this.iOrder.getInvoiceAddress().getCountry());
        this.addParameter("order.ourcontact", this.iOrder.getOurContactPerson());
        this.addParameter("order.deliveryterm", this.iOrder.getDeliveryTerm(), true);
        this.addParameter("order.deliveryway", this.iOrder.getDeliveryWay(), true);
        this.addParameter("order.paymentterm", this.iOrder.getPaymentTerm(), true);
        this.addParameter("order.delayinterest", this.iOrder.getDelayInterest(), true);
        this.addParameter("order.currency", this.iOrder.getCurrency(), true);
        this.addParameter("order.estimateddelivery", this.iOrder.getEstimatedDelivery(), true);
        this.addParameter("order.currency", this.iOrder.getCurrency(), true);
        this.addParameter("order.customernr", this.iOrder.getCustomerNr());
        this.addParameter("order.yourcontact", this.iOrder.getYourContactPerson());
        this.addParameter("order.yourordernumber", this.iOrder.getYourOrderNumber());
        this.addParameter("order.taxrate1", this.iOrder.getTaxRate1().toString());
        this.addParameter("order.taxrate2", this.iOrder.getTaxRate2().toString());
        this.addParameter("order.taxrate3", this.iOrder.getTaxRate3().toString());
        SSCustomer iCustomer = this.iOrder.getCustomer(SSDB.getInstance().getCustomers());
        if (iCustomer != null) {
            this.addParameter("order.vatnumber", iCustomer.getVATNumber());
        }
    }

    @Override
    protected SSDefaultTableModel getModel() {
        final SSRowReport iPrinter = new SSRowReport();
        iPrinter.setBundle(this.iBundle);
        iPrinter.setLocale(this.iLocale);
        iPrinter.generateReport();
        this.addParameter("subreport.report", iPrinter.getReport());
        this.addParameter("subreport.parameters", iPrinter.getParameters());
        this.addParameter("subreport.datasource", iPrinter.getDataSource());
        SSDefaultTableModel<SSOrder> iModel = new SSDefaultTableModel<SSOrder>(){

            @Override
            public Class getType() {
                return SSOrder.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                iPrinter.getDataSource().reset();
                return iPrinter.getDataSource();
            }
        };
        iModel.addColumn("subreport.datasource");
        iModel.setObjects(this.iOrder);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.sales.SSDeliverynotePrinter");
        sb.append("{iHideUnitprice=").append(this.iHideUnitprice);
        sb.append(", iLocale=").append(this.iLocale);
        sb.append(", iOrder=").append(this.iOrder);
        sb.append('}');
        return sb.toString();
    }

    private class SSRowReport
    extends SSPrinter {
        public SSRowReport() {
            this.setMargins(0, 0, 0, 0);
            if (!SSDeliverynotePrinter.this.iHideUnitprice) {
                this.setColumnHeader("sales/deliverynote.rows.jrxml");
                this.setDetail("sales/deliverynote.rows.jrxml");
                this.setPageFooter("sales/deliverynote.rows.jrxml");
                this.setLastPageFooter("sales/deliverynote.rows.jrxml");
            } else {
                this.setColumnHeader("sales/deliverynote2.rows.jrxml");
                this.setDetail("sales/deliverynote2.rows.jrxml");
                this.setPageFooter("sales/deliverynote2.rows.jrxml");
                this.setLastPageFooter("sales/deliverynote2.rows.jrxml");
            }
        }

        @Override
        protected SSDefaultTableModel getModel() {
            final List<SSProduct> iProducts = SSDB.getInstance().getProducts();
            SSDefaultTableModel<SSSaleRow> iModel = new SSDefaultTableModel<SSSaleRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSaleRow iRow = (SSSaleRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getDescription(SSDeliverynotePrinter.this.iLocale);
                            break;
                        }
                        case 2: {
                            value = iRow.getQuantity();
                            break;
                        }
                        case 3: {
                            value = iRow.getUnitprice();
                        }
                    }
                    SSProduct iProduct = iRow.getProduct(iProducts);
                    if (iProduct == null) {
                        return value;
                    }
                    switch (columnIndex) {
                        case 4: {
                            value = iProduct.getUnit() == null ? null : iProduct.getUnit().getName();
                            break;
                        }
                        case 5: {
                            value = iProduct.getWeight() == null ? new BigDecimal(0) : iProduct.getWeight();
                            break;
                        }
                        case 6: {
                            value = iProduct.getVolume() == null ? new BigDecimal(0) : iProduct.getVolume();
                        }
                    }
                    return value;
                }
            };
            iModel.addColumn("product.number");
            iModel.addColumn("product.description");
            iModel.addColumn("product.count");
            iModel.addColumn("product.unitprice");
            iModel.addColumn("product.unit");
            iModel.addColumn("product.weight");
            iModel.addColumn("product.volume");
            iModel.setObjects(SSDeliverynotePrinter.this.iOrder.getRows());
            return iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }
    }
}

