/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.sales;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSInvoiceType;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSSalePrinterUtils;

public class SSInvoicePrinter
extends SSPrinter {
    protected SSInvoice iInvoice;
    protected Locale iLocale;

    protected SSInvoicePrinter() {
    }

    public SSInvoicePrinter(SSInvoice iInvoice, Locale iLocale) {
        this.iInvoice = iInvoice;
        this.iLocale = iLocale;
        ResourceBundle iBundle = ResourceBundle.getBundle("reports.invoicereport", iLocale);
        this.setBundle(iBundle);
        this.setLocale(iLocale);
        this.setMargins(0, 0, 0, 0);
        this.setPageHeader("sales/sale.header.jrxml");
        this.setPageFooter("sales/sale.footer.jrxml");
        this.setDetail("sales/invoice.jrxml");
        this.setColumnHeader("sales/invoice.jrxml");
        this.addParameters();
    }

    @Override
    public String getTitle() {
        this.addParameter("title.date", this.iBundle.getString("invoicereport.title.date"));
        this.addParameter("title.number", this.iBundle.getString("invoicereport.title.number"));
        if (this.iInvoice.getType() == SSInvoiceType.NORMAL) {
            this.addParameter("invoicereport.totalsum", this.iBundle.getString("invoicereport.totalsum.normal"));
            return this.iBundle.getString("invoicereport.title.normal");
        }
        this.addParameter("invoicereport.totalsum", this.iBundle.getString("invoicereport.totalsum.cash"));
        return this.iBundle.getString("invoicereport.title.cash");
    }

    protected void addParameters() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSCustomer iCustomer = this.iInvoice.getCustomer(SSDB.getInstance().getCustomers());
        SSSalePrinterUtils.addParametersForCompany(iCompany, this);
        this.addParameter("number", this.iInvoice.getNumber());
        this.addParameter("date", this.iInvoice.getDate());
        this.addParameter("text", this.iInvoice.getText());
        this.addParameter("invoice.hasdiscount", SSInvoiceMath.hasDiscount(this.iInvoice));
        this.addParameter("invoice.deliveryadress.name", this.iInvoice.getDeliveryAddress().getName());
        this.addParameter("invoice.deliveryadress.address1", this.iInvoice.getDeliveryAddress().getAddress1());
        this.addParameter("invoice.deliveryadress.address2", this.iInvoice.getDeliveryAddress().getAddress2());
        this.addParameter("invoice.deliveryadress.zipcode", this.iInvoice.getDeliveryAddress().getZipCode());
        this.addParameter("invoice.deliveryadress.city", this.iInvoice.getDeliveryAddress().getCity());
        this.addParameter("invoice.deliveryadress.country", this.iInvoice.getDeliveryAddress().getCountry());
        this.addParameter("invoice.invoiceadress.name", this.iInvoice.getInvoiceAddress().getName());
        this.addParameter("invoice.invoiceadress.address1", this.iInvoice.getInvoiceAddress().getAddress1());
        this.addParameter("invoice.invoiceadress.address2", this.iInvoice.getInvoiceAddress().getAddress2());
        this.addParameter("invoice.invoiceadress.zipcode", this.iInvoice.getInvoiceAddress().getZipCode());
        this.addParameter("invoice.invoiceadress.city", this.iInvoice.getInvoiceAddress().getCity());
        this.addParameter("invoice.invoiceadress.country", this.iInvoice.getInvoiceAddress().getCountry());
        this.addParameter("invoice.ourcontact", this.iInvoice.getOurContactPerson());
        this.addParameter("invoice.deliveryterm", this.iInvoice.getDeliveryTerm(), true);
        this.addParameter("invoice.deliveryway", this.iInvoice.getDeliveryWay(), true);
        this.addParameter("invoice.paymentterm", this.iInvoice.getPaymentTerm(), true);
        this.addParameter("invoice.delayinterest", this.iInvoice.getDelayInterest(), true);
        this.addParameter("invoice.currency", this.iInvoice.getCurrency(), true);
        this.addParameter("invoice.customernr", this.iInvoice.getCustomerNr());
        this.addParameter("invoice.yourcontact", this.iInvoice.getYourContactPerson());
        this.addParameter("invoice.yourordernumber", this.iInvoice.getYourOrderNumber());
        this.addParameter("invoice.paymentday", this.iInvoice.getDueDate());
        this.addParameter("invoice.taxrate1", this.iInvoice.getTaxRate1().toString());
        this.addParameter("invoice.taxrate2", this.iInvoice.getTaxRate2().toString());
        this.addParameter("invoice.taxrate3", this.iInvoice.getTaxRate3().toString());
        if (iCustomer != null) {
            this.addParameter("invoice.vatnumber", iCustomer.getVATNumber());
        }
        BigDecimal iNetSum = SSInvoiceMath.getNetSum(this.iInvoice);
        Map<SSTaxCode, BigDecimal> iTaxSum = SSInvoiceMath.getTaxSum(this.iInvoice);
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(this.iInvoice);
        BigDecimal iRounding = SSInvoiceMath.getRounding(this.iInvoice);
        this.addParameter("invoice.netsum", iNetSum);
        this.addParameter("invoice.taxsum1", iTaxSum.get(SSTaxCode.TAXRATE_1));
        this.addParameter("invoice.taxsum2", iTaxSum.get(SSTaxCode.TAXRATE_2));
        this.addParameter("invoice.taxsum3", iTaxSum.get(SSTaxCode.TAXRATE_3));
        this.addParameter("invoice.rounding", iRounding);
        this.addParameter("invoice.totalsum", iTotalSum);
    }

    @Override
    protected SSDefaultTableModel getModel() {
        final SSRowReport iPrinter = new SSRowReport();
        iPrinter.setBundle(this.iBundle);
        iPrinter.setLocale(this.iLocale);
        iPrinter.generateReport();
        iPrinter.getDataSource().reset();
        this.addParameter("subreport.report", iPrinter.getReport());
        this.addParameter("subreport.parameters", iPrinter.getParameters());
        this.addParameter("subreport.datasource", iPrinter.getDataSource());
        SSDefaultTableModel<SSInvoice> iModel = new SSDefaultTableModel<SSInvoice>(){

            @Override
            public Class getType() {
                return SSInvoice.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                iPrinter.getDataSource().reset();
                return this.getObject(rowIndex);
            }
        };
        iModel.setObjects(this.iInvoice);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.sales.SSInvoicePrinter");
        sb.append("{iInvoice=").append(this.iInvoice);
        sb.append(", iLocale=").append(this.iLocale);
        sb.append('}');
        return sb.toString();
    }

    private class SSRowReport
    extends SSPrinter {
        public SSRowReport() {
            this.setMargins(0, 0, 0, 0);
            this.setColumnHeader("sales/invoice.rows.jrxml");
            this.setDetail("sales/invoice.rows.jrxml");
            this.setPageFooter("sales/invoice.rows.jrxml");
            this.setLastPageFooter("sales/invoice.rows.jrxml");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            SSDefaultTableModel<SSSaleRow> iModel = new SSDefaultTableModel<SSSaleRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSaleRow iRow = (SSSaleRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getDescription(SSInvoicePrinter.this.iLocale);
                            break;
                        }
                        case 2: {
                            value = iRow.getQuantity();
                            break;
                        }
                        case 3: {
                            value = iRow.getUnit() == null ? null : iRow.getUnit().getName();
                            break;
                        }
                        case 4: {
                            value = iRow.getUnitprice();
                            break;
                        }
                        case 5: {
                            value = iRow.getDiscount();
                            break;
                        }
                        case 6: {
                            value = iRow.getSum();
                        }
                    }
                    return value;
                }
            };
            iModel.addColumn("row.number");
            iModel.addColumn("row.description");
            iModel.addColumn("row.count");
            iModel.addColumn("row.unit");
            iModel.addColumn("row.unitprice");
            iModel.addColumn("row.discount");
            iModel.addColumn("row.sum");
            LinkedList<SSSaleRow> iRows = new LinkedList<SSSaleRow>(SSInvoicePrinter.this.iInvoice.getRows());
            if (SSInvoicePrinter.this.iInvoice.getOrderNumbers() != null && SSInvoicePrinter.this.iInvoice.getOrderNumbers().length() != 0 && !SSInvoicePrinter.this.iInvoice.getOrderNumbers().equals("Fakturan har inga ordrar")) {
                SSSaleRow iRow = new SSSaleRow();
                iRow.setProductNr(SSInvoicePrinter.this.iLocale.getLanguage().equals("en") ? "Contains order:" : "Avser order:");
                iRow.setDescription(SSInvoicePrinter.this.iInvoice.getOrderNumbers());
                iRows.add(iRow);
            }
            iModel.setObjects((List<SSSaleRow>)iRows);
            return iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }
    }
}

