/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.sales;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSSalePrinterUtils;

public class SSPickingslipPrinter
extends SSPrinter {
    private SSOrder iOrder;
    private Locale iLocale;

    public SSPickingslipPrinter(SSOrder iOrder, Locale iLocale) {
        this.iOrder = iOrder;
        this.iLocale = iLocale;
        ResourceBundle iBundle = ResourceBundle.getBundle("reports.pickingslipreport", iLocale);
        this.setBundle(iBundle);
        this.setLocale(iLocale);
        this.setMargins(0, 0, 0, 0);
        this.setPageHeader("sales/sale.header.jrxml");
        this.setPageFooter("sales/sale.footer.jrxml");
        this.setDetail("sales/pickingslip.jrxml");
        this.setColumnHeader("sales/pickingslip.jrxml");
        this.addParameters();
    }

    @Override
    public String getTitle() {
        this.addParameter("title.date", this.iBundle.getString("pickingslipreport.title.date"));
        this.addParameter("title.number", this.iBundle.getString("pickingslipreport.title.number"));
        return this.iBundle.getString("pickingslipreport.title");
    }

    private void addParameters() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSSalePrinterUtils.addParametersForCompany(iCompany, this);
        this.addParameter("number", this.iOrder.getNumber());
        this.addParameter("date", this.iOrder.getDate());
        this.addParameter("text", this.iOrder.getText());
        this.addParameter("order.deliveryadress.name", this.iOrder.getDeliveryAddress().getName());
        this.addParameter("order.deliveryadress.address1", this.iOrder.getDeliveryAddress().getAddress1());
        this.addParameter("order.deliveryadress.address2", this.iOrder.getDeliveryAddress().getAddress2());
        this.addParameter("order.deliveryadress.zipcode", this.iOrder.getDeliveryAddress().getZipCode());
        this.addParameter("order.deliveryadress.city", this.iOrder.getDeliveryAddress().getCity());
        this.addParameter("order.deliveryadress.country", this.iOrder.getDeliveryAddress().getCountry());
        this.addParameter("order.invoiceadress.name", this.iOrder.getInvoiceAddress().getName());
        this.addParameter("order.invoiceadress.address1", this.iOrder.getInvoiceAddress().getAddress1());
        this.addParameter("order.invoiceadress.address2", this.iOrder.getInvoiceAddress().getAddress2());
        this.addParameter("order.invoiceadress.zipcode", this.iOrder.getInvoiceAddress().getZipCode());
        this.addParameter("order.invoiceadress.city", this.iOrder.getInvoiceAddress().getCity());
        this.addParameter("order.invoiceadress.country", this.iOrder.getInvoiceAddress().getCountry());
        this.addParameter("order.ourcontact", this.iOrder.getOurContactPerson());
        this.addParameter("order.deliveryterm", this.iOrder.getDeliveryTerm(), true);
        this.addParameter("order.deliveryway", this.iOrder.getDeliveryWay(), true);
        this.addParameter("order.paymentterm", this.iOrder.getPaymentTerm(), true);
        this.addParameter("order.delayinterest", this.iOrder.getDelayInterest(), true);
        this.addParameter("order.currency", this.iOrder.getCurrency(), true);
        this.addParameter("order.estimateddelivery", this.iOrder.getEstimatedDelivery(), true);
        this.addParameter("order.customernr", this.iOrder.getCustomerNr());
        this.addParameter("order.yourcontact", this.iOrder.getYourContactPerson());
        this.addParameter("order.yourordernumber", this.iOrder.getYourOrderNumber());
        this.addParameter("order.taxrate1", this.iOrder.getTaxRate1().toString());
        this.addParameter("order.taxrate2", this.iOrder.getTaxRate2().toString());
        this.addParameter("order.taxrate3", this.iOrder.getTaxRate3().toString());
    }

    @Override
    protected SSDefaultTableModel getModel() {
        final SSRowReport iPrinter = new SSRowReport();
        iPrinter.setBundle(this.iBundle);
        iPrinter.setLocale(this.iLocale);
        iPrinter.generateReport();
        this.addParameter("subreport.report", iPrinter.getReport());
        this.addParameter("subreport.parameters", iPrinter.getParameters());
        this.addParameter("subreport.datasource", iPrinter.getDataSource());
        SSDefaultTableModel<SSOrder> iModel = new SSDefaultTableModel<SSOrder>(){

            @Override
            public Class getType() {
                return SSOrder.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                iPrinter.getDataSource().reset();
                return iPrinter.getDataSource();
            }
        };
        iModel.addColumn("subreport.datasource");
        iModel.setObjects(this.iOrder);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.sales.SSPickingslipPrinter");
        sb.append("{iLocale=").append(this.iLocale);
        sb.append(", iOrder=").append(this.iOrder);
        sb.append('}');
        return sb.toString();
    }

    private class SSRowReport
    extends SSPrinter {
        public SSRowReport() {
            this.setMargins(0, 0, 0, 0);
            this.setColumnHeader("sales/pickingslip.rows.jrxml");
            this.setDetail("sales/pickingslip.rows.jrxml");
            this.setPageFooter("sales/pickingslip.rows.jrxml");
            this.setLastPageFooter("sales/pickingslip.rows.jrxml");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            final List<SSProduct> iProducts = SSDB.getInstance().getProducts();
            SSDefaultTableModel<SSSaleRow> iModel = new SSDefaultTableModel<SSSaleRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSaleRow iRow = (SSSaleRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getDescription(SSPickingslipPrinter.this.iLocale);
                            break;
                        }
                        case 2: {
                            value = iRow.getQuantity();
                        }
                    }
                    SSProduct iProduct = iRow.getProduct(iProducts);
                    if (iProduct == null) {
                        return value;
                    }
                    switch (columnIndex) {
                        case 3: {
                            value = iProduct.getWarehouseLocation();
                            break;
                        }
                        case 4: {
                            value = iProduct.getUnit() == null ? null : iProduct.getUnit().getName();
                            break;
                        }
                        case 5: {
                            value = iProduct.getWeight() == null ? new BigDecimal(0) : iProduct.getWeight();
                            break;
                        }
                        case 6: {
                            value = iProduct.getVolume() == null ? new BigDecimal(0) : iProduct.getVolume();
                        }
                    }
                    return value;
                }
            };
            iModel.addColumn("product.number");
            iModel.addColumn("product.description");
            iModel.addColumn("product.count");
            iModel.addColumn("product.warehouselocation");
            iModel.addColumn("product.unit");
            iModel.addColumn("product.weight");
            iModel.addColumn("product.volume");
            LinkedList<SSSaleRow> iRows = new LinkedList<SSSaleRow>(SSPickingslipPrinter.this.iOrder.getRows());
            Collections.sort(iRows, new Comparator(){

                public int compare(Object iRow1, Object iRow2) {
                    SSSaleRow iSaleRow1 = (SSSaleRow)iRow1;
                    SSSaleRow iSaleRow2 = (SSSaleRow)iRow2;
                    SSProduct iProduct1 = SSDB.getInstance().getProduct(iSaleRow1.getProductNr());
                    SSProduct iProduct2 = SSDB.getInstance().getProduct(iSaleRow2.getProductNr());
                    if (iProduct1 != null && iProduct2 != null) {
                        if (iProduct1.getWarehouseLocation() == null && iProduct2.getWarehouseLocation() == null) {
                            return 0;
                        }
                        if (iProduct1.getWarehouseLocation() != null && iProduct2.getWarehouseLocation() == null) {
                            return 1;
                        }
                        if (iProduct1.getWarehouseLocation() == null && iProduct2.getWarehouseLocation() != null) {
                            return -1;
                        }
                        return iProduct1.getWarehouseLocation().compareTo(iProduct2.getWarehouseLocation());
                    }
                    if (iProduct1 == null && iProduct2 == null) {
                        return 0;
                    }
                    if (iProduct1 != null) {
                        return -1;
                    }
                    return 1;
                }
            });
            iModel.setObjects((List<SSSaleRow>)iRows);
            return iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }
    }
}

