/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.report.sales;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSaleMath;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.print.SSPrinter;
import se.swedsoft.bookkeeping.print.report.sales.SSSalePrinterUtils;

public class SSTenderPrinter
extends SSPrinter {
    private SSTender iTender;
    private Locale iLocale;

    public SSTenderPrinter(SSTender iTender, Locale iLocale) {
        this.iTender = iTender;
        this.iLocale = iLocale;
        ResourceBundle iBundle = ResourceBundle.getBundle("reports.tenderreport", iLocale);
        this.setBundle(iBundle);
        this.setLocale(iLocale);
        this.setMargins(0, 0, 0, 0);
        this.setPageHeader("sales/sale.header.jrxml");
        this.setPageFooter("sales/sale.footer.jrxml");
        this.setDetail("sales/tender.jrxml");
        this.setColumnHeader("sales/tender.jrxml");
        this.addParameters();
    }

    @Override
    public String getTitle() {
        this.addParameter("title.date", this.iBundle.getString("tenderreport.title.date"));
        this.addParameter("title.number", this.iBundle.getString("tenderreport.title.number"));
        return this.iBundle.getString("tenderreport.title");
    }

    private void addParameters() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        SSSalePrinterUtils.addParametersForCompany(iCompany, this);
        this.addParameter("number", this.iTender.getNumber());
        this.addParameter("date", this.iTender.getDate());
        this.addParameter("text", this.iTender.getText());
        this.addParameter("tender.hasdiscount", SSSaleMath.hasDiscount(this.iTender));
        this.addParameter("tender.deliveryadress.name", this.iTender.getDeliveryAddress().getName());
        this.addParameter("tender.deliveryadress.address1", this.iTender.getDeliveryAddress().getAddress1());
        this.addParameter("tender.deliveryadress.address2", this.iTender.getDeliveryAddress().getAddress2());
        this.addParameter("tender.deliveryadress.zipcode", this.iTender.getDeliveryAddress().getZipCode());
        this.addParameter("tender.deliveryadress.city", this.iTender.getDeliveryAddress().getCity());
        this.addParameter("tender.deliveryadress.country", this.iTender.getDeliveryAddress().getCountry());
        this.addParameter("tender.invoiceadress.name", this.iTender.getInvoiceAddress().getName());
        this.addParameter("tender.invoiceadress.address1", this.iTender.getInvoiceAddress().getAddress1());
        this.addParameter("tender.invoiceadress.address2", this.iTender.getInvoiceAddress().getAddress2());
        this.addParameter("tender.invoiceadress.zipcode", this.iTender.getInvoiceAddress().getZipCode());
        this.addParameter("tender.invoiceadress.city", this.iTender.getInvoiceAddress().getCity());
        this.addParameter("tender.invoiceadress.country", this.iTender.getInvoiceAddress().getCountry());
        this.addParameter("tender.ourcontact", this.iTender.getOurContactPerson());
        this.addParameter("tender.deliveryterm", this.iTender.getDeliveryTerm(), true);
        this.addParameter("tender.deliveryway", this.iTender.getDeliveryWay(), true);
        this.addParameter("tender.paymentterm", this.iTender.getPaymentTerm(), true);
        this.addParameter("tender.delayinterest", this.iTender.getDelayInterest(), true);
        this.addParameter("tender.currency", this.iTender.getCurrency(), true);
        this.addParameter("tender.customernr", this.iTender.getCustomerNr());
        this.addParameter("tender.yourcontact", this.iTender.getYourContactPerson());
        this.addParameter("tender.taxrate1", this.iTender.getTaxRate1().toString());
        this.addParameter("tender.taxrate2", this.iTender.getTaxRate2().toString());
        this.addParameter("tender.taxrate3", this.iTender.getTaxRate3().toString());
        BigDecimal iNetSum = SSInvoiceMath.getNetSum(this.iTender);
        Map<SSTaxCode, BigDecimal> iTaxSum = SSInvoiceMath.getTaxSum(this.iTender);
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(this.iTender);
        BigDecimal iRounding = SSInvoiceMath.getRounding(this.iTender);
        this.addParameter("tender.netsum", iNetSum);
        this.addParameter("tender.taxsum1", iTaxSum.get(SSTaxCode.TAXRATE_1));
        this.addParameter("tender.taxsum2", iTaxSum.get(SSTaxCode.TAXRATE_2));
        this.addParameter("tender.taxsum3", iTaxSum.get(SSTaxCode.TAXRATE_3));
        this.addParameter("tender.rounding", iRounding);
        this.addParameter("tender.totalsum", iTotalSum);
    }

    @Override
    protected SSDefaultTableModel getModel() {
        final SSRowReport iPrinter = new SSRowReport();
        iPrinter.setBundle(this.iBundle);
        iPrinter.setLocale(this.iLocale);
        iPrinter.generateReport();
        this.addParameter("subreport.report", iPrinter.getReport());
        this.addParameter("subreport.parameters", iPrinter.getParameters());
        this.addParameter("subreport.datasource", iPrinter.getDataSource());
        SSDefaultTableModel<SSTender> iModel = new SSDefaultTableModel<SSTender>(){

            @Override
            public Class getType() {
                return SSTender.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                iPrinter.getDataSource().reset();
                return iPrinter.getDataSource();
            }
        };
        iModel.addColumn("subreport.datasource");
        iModel.setObjects(this.iTender);
        return iModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.report.sales.SSTenderPrinter");
        sb.append("{iLocale=").append(this.iLocale);
        sb.append(", iTender=").append(this.iTender);
        sb.append('}');
        return sb.toString();
    }

    private class SSRowReport
    extends SSPrinter {
        public SSRowReport() {
            this.setMargins(0, 0, 0, 0);
            this.setColumnHeader("sales/tender.rows.jrxml");
            this.setDetail("sales/tender.rows.jrxml");
            this.setPageFooter("sales/tender.rows.jrxml");
            this.setLastPageFooter("sales/tender.rows.jrxml");
        }

        @Override
        protected SSDefaultTableModel getModel() {
            SSDefaultTableModel<SSSaleRow> iModel = new SSDefaultTableModel<SSSaleRow>(){

                @Override
                public Class getType() {
                    return SSSaleRow.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    Object value = null;
                    SSSaleRow iRow = (SSSaleRow)this.getObject(rowIndex);
                    switch (columnIndex) {
                        case 0: {
                            value = iRow.getProductNr();
                            break;
                        }
                        case 1: {
                            value = iRow.getDescription(SSTenderPrinter.this.iLocale);
                            break;
                        }
                        case 2: {
                            value = iRow.getQuantity();
                            break;
                        }
                        case 3: {
                            value = iRow.getUnit() == null ? null : iRow.getUnit().getName();
                            break;
                        }
                        case 4: {
                            value = iRow.getUnitprice();
                            break;
                        }
                        case 5: {
                            value = iRow.getDiscount();
                            break;
                        }
                        case 6: {
                            value = iRow.getSum();
                        }
                    }
                    return value;
                }
            };
            iModel.addColumn("row.number");
            iModel.addColumn("row.description");
            iModel.addColumn("row.count");
            iModel.addColumn("row.unit");
            iModel.addColumn("row.unitprice");
            iModel.addColumn("row.discount");
            iModel.addColumn("row.sum");
            iModel.setObjects(SSTenderPrinter.this.iTender.getRows());
            return iModel;
        }

        @Override
        public String getTitle() {
            return null;
        }
    }
}

