/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;

public class SSDefaultJasperDataSource
implements JRRewindableDataSource {
    private SSDefaultTableModel iModel;
    private int iRow;
    private Map<String, Integer> iColumnIndices;

    public SSDefaultJasperDataSource(SSDefaultTableModel model) {
        this.iModel = model;
        this.iRow = -1;
        List<String> columns = this.iModel.getColumnNames();
        this.iColumnIndices = new HashMap<String, Integer>(columns.size() << 1);
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            this.iColumnIndices.put(columns.get(i), i);
        }
    }

    public void reset() {
        this.iRow = -1;
    }

    @Override
    public void moveFirst() {
        this.iRow = -1;
    }

    @Override
    public boolean next() throws JRException {
        ++this.iRow;
        return this.iRow < this.iModel.getRowCount();
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        Integer column = this.iColumnIndices.get(jrField.getName());
        return column != null ? this.iModel.getValueAt(this.iRow, column) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.util.SSDefaultJasperDataSource");
        sb.append("{iColumnIndices=").append(this.iColumnIndices);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iRow=").append(this.iRow);
        sb.append('}');
        return sb.toString();
    }
}

