/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import se.swedsoft.bookkeeping.app.Path;
import se.swedsoft.bookkeeping.app.Version;
import se.swedsoft.bookkeeping.util.SSException;

public class SSReportCache {
    private static final File REPORT_DIR = new File(Path.get(Path.APP_DATA), "report");
    private static final File COMPILED_DIR = new File(REPORT_DIR, "compiled");
    private static final String REPORT_RESOURCE = "/reports/report/";
    private static final String DATE_TIME_FORMAT_NO_MS = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private Map<String, JasperReport> iReportCache = new HashMap<String, JasperReport>();
    private static SSReportCache cInstance;

    public static SSReportCache getInstance() {
        if (cInstance == null) {
            cInstance = new SSReportCache();
        }
        return cInstance;
    }

    private SSReportCache() {
    }

    public JasperReport getReport(String pReportName) throws SSException {
        JasperReport pReport = this.iReportCache.get(pReportName);
        if (pReport == null) {
            try {
                pReport = this.loadReport(pReportName);
            }
            catch (FileNotFoundException ex) {
                throw new SSException(ex.getLocalizedMessage());
            }
            this.iReportCache.put(pReportName, pReport);
        }
        return pReport;
    }

    private JasperReport loadReport(String pReportName) throws FileNotFoundException {
        File iReportFile = new File(REPORT_DIR, pReportName);
        File iCompiledFile = new File(COMPILED_DIR, pReportName.replace(".jrxml", ".jasperreport"));
        String iReportResource = REPORT_RESOURCE + pReportName;
        try {
            if (iCompiledFile.exists()) {
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT_NO_MS);
                try {
                    Date iReportDate = sdf.parse(Version.APP_BUILD);
                    Date iCompiledDate = new Date(iCompiledFile.lastModified());
                    if (iReportDate.compareTo(iCompiledDate) <= 0) {
                        System.out.printf("Loading precompiled report %s from disk...\n", iCompiledFile);
                        return this.loadCompiledReport(iCompiledFile);
                    }
                }
                catch (ParseException ex) {
                    System.out.println(ex.getMessage());
                }
                System.out.println("Precompiled report exists, but report is changed ...");
            }
            System.out.printf("Compiling and saving report %s to disk...\n", iReportResource);
            InputStream is = this.getClass().getResourceAsStream(iReportResource);
            JasperReport iReport = JasperCompileManager.compileReport(is);
            iCompiledFile.getParentFile().mkdirs();
            return this.saveCompiledReport(iCompiledFile, iReport);
        }
        catch (JRException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private JasperReport loadCompiledReport(File pCompiledFile) {
        try {
            FileInputStream iFileInputStream = new FileInputStream(pCompiledFile);
            ObjectInputStream iObjectInputStream = new ObjectInputStream(new BufferedInputStream(iFileInputStream));
            return (JasperReport)iObjectInputStream.readObject();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private JasperReport saveCompiledReport(File pCompiledFile, JasperReport pReport) {
        try {
            FileOutputStream iFileOutputStream = new FileOutputStream(pCompiledFile);
            ObjectOutputStream iObjectOutputStream = new ObjectOutputStream(new BufferedOutputStream(iFileOutputStream));
            iObjectOutputStream.writeObject(pReport);
            iObjectOutputStream.flush();
            return pReport;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.util.SSReportCache");
        sb.append("{iReportCache=").append(this.iReportCache);
        sb.append('}');
        return sb.toString();
    }
}

