/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.print.view;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.save.JRMultipleSheetsXlsSaveContributor;
import net.sf.jasperreports.view.save.JRRtfSaveContributor;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.status.SSStatusBar;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSJasperFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.util.SSFilterHTM;
import se.swedsoft.bookkeeping.gui.util.filechooser.util.SSFilterPDF;
import se.swedsoft.bookkeeping.gui.util.filechooser.util.SSFilterRTF;
import se.swedsoft.bookkeeping.gui.util.filechooser.util.SSFilterXLS;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.print.SSReport;
import se.swedsoft.bookkeeping.print.view.SSViewer;
import se.swedsoft.bookkeeping.print.view.SSZoomLevel;

public class SSJasperPreviewFrame
extends SSDefaultTableFrame
implements PropertyChangeListener {
    public static ResourceBundle bundle = SSBundle.getBundle();
    private JasperPrint iPrinter;
    private SSViewer iViewer;
    private JLabel iPageLabel;
    private JComboBox iZoomLevels;
    private SSReport iReport;
    SSButton iFirst;
    SSButton iBack;
    SSButton iForward;
    SSButton iLast;

    public SSJasperPreviewFrame(SSMainFrame frame, int width, int height) {
        super(frame, SSBundle.getBundle().getString("printpreviewframe.title"), width, height);
        this.iViewer.addPropertyChangeListener("page_zoom", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSJasperPreviewFrame.this.updateStatusBar();
            }
        });
        this.iViewer.addPropertyChangeListener("page_change", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSJasperPreviewFrame.this.updateStatusBar();
            }
        });
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolbar = new JToolBar();
        this.iZoomLevels = new JComboBox<SSZoomLevel>(SSZoomLevel.values());
        this.iZoomLevels.setEditable(true);
        this.iZoomLevels.setMaximumSize(new Dimension(75, 20));
        this.iZoomLevels.setSelectedItem((Object)SSZoomLevel.ZOOM_100);
        SSButton iButton = new SSButton("ICON_SAVEITEM", "printpreviewframe.savebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSJasperFileChooser iFileChooser = SSJasperFileChooser.getInstance();
                if (SSJasperPreviewFrame.this.iReport != null) {
                    String iTitle = (String)SSJasperPreviewFrame.this.iReport.getParameter("title");
                    iFileChooser.setSelectedFile(new File(iTitle + ".pdf"));
                } else {
                    iFileChooser.setSelectedFile(new File("Rapport.pdf"));
                }
                if (iFileChooser.showSaveDialog(SSJasperPreviewFrame.this) == 0) {
                    SSJasperPreviewFrame.this.saveDocument(iFileChooser.getFileFilter(), iFileChooser.getSelectedFile());
                }
            }
        });
        iButton.setDefaultSize();
        toolbar.add(iButton);
        iButton = new SSButton("ICON_PRINT", "printpreviewframe.printbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JasperPrintManager.printReport(SSJasperPreviewFrame.this.iPrinter, true);
                }
                catch (JRException ex) {
                    ex.printStackTrace();
                }
            }
        });
        iButton.setDefaultSize();
        toolbar.add(iButton);
        toolbar.addSeparator();
        this.iFirst = new SSButton("ICON_FIRST", "printpreviewframe.firstbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSJasperPreviewFrame.this.iViewer.firstPage();
            }
        });
        this.iFirst.setDefaultSize();
        toolbar.add(this.iFirst);
        this.iBack = new SSButton("ICON_BACK", "printpreviewframe.prevbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSJasperPreviewFrame.this.iViewer.prevPage();
            }
        });
        this.iBack.setDefaultSize();
        toolbar.add(this.iBack);
        this.iForward = new SSButton("ICON_FORWARD", "printpreviewframe.nextbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSJasperPreviewFrame.this.iViewer.nextPage();
            }
        });
        this.iForward.setDefaultSize();
        toolbar.add(this.iForward);
        this.iLast = new SSButton("ICON_LAST", "printpreviewframe.lastbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSJasperPreviewFrame.this.iViewer.lastPage();
            }
        });
        this.iLast.setDefaultSize();
        toolbar.add(this.iLast);
        toolbar.addSeparator();
        iButton = new SSButton("ICON_ZOOMIN", "printpreviewframe.zoominbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SSJasperPreviewFrame.this.iZoomLevels.getSelectedIndex() - 1;
                if (index >= 0) {
                    SSJasperPreviewFrame.this.iZoomLevels.setSelectedItem((Object)SSZoomLevel.values()[index]);
                }
            }
        });
        iButton.setDefaultSize();
        toolbar.add(iButton);
        iButton = new SSButton("ICON_ZOOMOUT", "printpreviewframe.zoomoutbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SSJasperPreviewFrame.this.iZoomLevels.getSelectedIndex() + 2;
                if (index < SSZoomLevel.values().length) {
                    SSJasperPreviewFrame.this.iZoomLevels.setSelectedItem((Object)SSZoomLevel.values()[index - 1]);
                }
            }
        });
        iButton.setDefaultSize();
        toolbar.add(iButton);
        toolbar.addSeparator();
        this.iZoomLevels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int iZoom;
                try {
                    if (SSJasperPreviewFrame.this.iZoomLevels.getSelectedIndex() >= 0) {
                        SSZoomLevel iSelected = (SSZoomLevel)((Object)SSJasperPreviewFrame.this.iZoomLevels.getSelectedItem());
                        iZoom = iSelected.getZoom();
                    } else {
                        iZoom = Integer.parseInt((String)SSJasperPreviewFrame.this.iZoomLevels.getSelectedItem());
                    }
                }
                catch (NumberFormatException e1) {
                    return;
                }
                SSJasperPreviewFrame.this.iViewer.setZoom(iZoom);
            }
        });
        toolbar.add(this.iZoomLevels);
        this.iViewer.addPropertyChangeListener("page_change", this);
        return toolbar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int iCount = this.iViewer.getPageCount();
        int iCurrent = this.iViewer.getCurrentPage();
        this.iFirst.setEnabled(iCurrent > 0);
        this.iBack.setEnabled(iCurrent > 0);
        this.iForward.setEnabled(iCurrent < iCount - 1);
        this.iLast.setEnabled(iCurrent < iCount - 1);
    }

    @Override
    public JComponent getMainContent() {
        this.iViewer = new SSViewer();
        JScrollPane iScrollPane = new JScrollPane(this.iViewer);
        iScrollPane.setHorizontalScrollBarPolicy(32);
        iScrollPane.setVerticalScrollBarPolicy(22);
        return iScrollPane;
    }

    @Override
    public JComponent getStatusBar() {
        this.iPageLabel = new JLabel();
        SSStatusBar iStatusBar = new SSStatusBar();
        iStatusBar.addSpacer();
        iStatusBar.addPanel(this.iPageLabel);
        return iStatusBar;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    public void setPrinter(JasperPrint iPrinter) {
        this.iPrinter = iPrinter;
        this.iViewer.setPrinter(iPrinter);
    }

    public void setReport(SSReport iReport) {
        this.iReport = iReport;
    }

    private void updateStatusBar() {
        int iCurrent = this.iViewer.getCurrentPage() + 1;
        int iTotal = this.iViewer.getPageCount();
        this.iPageLabel.setText(String.format(bundle.getString("printpreviewframe.pages"), iCurrent, iTotal));
    }

    private void saveDocument(FileFilter pFileFilter, File pSelectedFile) {
        JRSaveContributor iSaver;
        String iFileName = pSelectedFile.getAbsolutePath();
        String iFileExt = this.getExtension(pSelectedFile);
        if (iFileExt.equals("pdf") || iFileExt.length() == 0 && pFileFilter instanceof SSFilterPDF) {
            try {
                if (iFileExt.length() == 0) {
                    iFileName = iFileName + ".pdf";
                }
                JasperExportManager.exportReportToPdfFile(this.iPrinter, iFileName);
            }
            catch (JRException ex) {
                ex.printStackTrace();
            }
        }
        if (iFileExt.equals("htm") || iFileExt.equals("html") || iFileExt.length() == 0 && pFileFilter instanceof SSFilterHTM) {
            try {
                if (iFileExt.length() == 0) {
                    iFileName = iFileName + ".htm";
                }
                JasperExportManager.exportReportToHtmlFile(this.iPrinter, iFileName);
            }
            catch (JRException ex) {
                ex.printStackTrace();
            }
        }
        if (iFileExt.equals(".rtf") || iFileExt.length() == 0 && pFileFilter instanceof SSFilterRTF) {
            try {
                iSaver = new JRRtfSaveContributor(new Locale("sv", "SE"), bundle);
                ((JRRtfSaveContributor)iSaver).save(this.iPrinter, pSelectedFile);
            }
            catch (JRException ex) {
                ex.printStackTrace();
            }
        }
        if (iFileExt.equals(".xls") || iFileExt.length() == 0 && pFileFilter instanceof SSFilterXLS) {
            try {
                iSaver = new JRMultipleSheetsXlsSaveContributor(new Locale("sv", "SE"), bundle);
                ((JRMultipleSheetsXlsSaveContributor)iSaver).save(this.iPrinter, pSelectedFile);
            }
            catch (JRException ex) {
                ex.printStackTrace();
            }
        }
    }

    private String getExtension(File pFile) {
        String ext = null;
        String s = pFile.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext == null ? "" : ext.toLowerCase();
    }

    public void actionPerformed(ActionEvent e) {
        this.iPrinter = null;
        this.iViewer = null;
        this.iPageLabel = null;
        this.iZoomLevels = null;
        this.iReport = null;
        this.iFirst = null;
        this.iBack = null;
        this.iForward = null;
        this.iLast = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.print.view.SSJasperPreviewFrame");
        sb.append("{iBack=").append(this.iBack);
        sb.append(", iFirst=").append(this.iFirst);
        sb.append(", iForward=").append(this.iForward);
        sb.append(", iLast=").append(this.iLast);
        sb.append(", iPageLabel=").append(this.iPageLabel);
        sb.append(", iPrinter=").append(this.iPrinter);
        sb.append(", iReport=").append(this.iReport);
        sb.append(", iViewer=").append(this.iViewer);
        sb.append(", iZoomLevels=").append(this.iZoomLevels);
        sb.append('}');
        return sb.toString();
    }
}

