/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class BrowserLaunch {
    private static final String osname = System.getProperty("os.name").toLowerCase();
    private static final boolean MAC_OS_X = osname.startsWith("mac os x");
    private static final boolean WINDOWS = osname.startsWith("windows");

    private BrowserLaunch() {
    }

    public static void openURL(URL url) {
        BrowserLaunch.openURL(url.toString());
    }

    public static void openURL(String url) {
        String error = null;
        try {
            if (WINDOWS) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                ArrayList<String> browsers = new ArrayList<String>(10);
                String env = System.getenv("BROWSER");
                if (env != null) {
                    browsers.addAll(Arrays.asList(env.split(":")));
                }
                if (MAC_OS_X) {
                    browsers.addAll(Arrays.asList("firefox", "chrome", "safari", "mozilla", "opera", "netscape"));
                } else {
                    browsers.addAll(Arrays.asList("firefox", "epiphany", "konqueror", "mozilla", "opera", "netscape"));
                }
                String browser = null;
                for (String br : browsers) {
                    Process process = Runtime.getRuntime().exec(new String[]{"which", br});
                    try {
                        if (process.waitFor() != 0) continue;
                        browser = br;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (browser != null) {
                    String[] commandLine = new String[]{browser, url};
                    Process process = Runtime.getRuntime().exec(commandLine);
                } else {
                    error = "Could not find web browser";
                }
            }
        }
        catch (IOException e) {
            error = e.getMessage();
        }
        if (error != null) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + error);
        }
    }
}

